/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.PDBaseClassSinglePrimaryKey;
import de.mpc.PD.PD_GUID;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.ProcessingNodes;
import java.sql.SQLException;

public class ProcessingNodeScores
extends PDBaseClassSinglePrimaryKey {
    private long scoreID = -1L;
    private int processingNodeID;
    private String scoreName;
    private String friendlyName;
    private String description;
    private String formatString;
    private int scoreCategory;
    private boolean hidden;
    private boolean isMainScore;
    private PD_GUID scoreGUID = null;
    private ProcessingNodes processingNode = null;

    public ProcessingNodeScores(AProgramParameters pp, long scoreID) {
        super(pp);
        this.scoreID = scoreID;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select ProcessingNodeID, ScoreName, Friendlyname, Description, FormatString, Scorecategory, Hidden, IsMainScore, ScoreGUID").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where ScoreID = ?");
        this.initAndProcessPrepared(this.scoreID);
    }

    private void loadForeignKeyObjects() {
        if ((long)this.processingNodeID > -1L && this.processingNode == null) {
            this.processingNode = this.requestProcessingNode(this.processingNodeID);
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private ProcessingNodes requestProcessingNode(long processingNodeID) {
        return new ProcessingNodes(this.getPP(), processingNodeID);
    }

    private void loadGUIDObjects() {
        if (this.scoreGUID != null) assert (this.isNotNull((Object)this.scoreGUID));
        this.bGUIDObjectsLoaded = true;
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.processingNodeID = this.sql4javaSt.columnInt(this.colIndex++);
                this.scoreName = this.sql4javaSt.columnString(this.colIndex++);
                this.friendlyName = this.sql4javaSt.columnString(this.colIndex++);
                this.description = this.sql4javaSt.columnString(this.colIndex++);
                this.formatString = this.sql4javaSt.columnString(this.colIndex++);
                this.scoreCategory = this.sql4javaSt.columnInt(this.colIndex++);
                this.hidden = this.sql4javaSt.columnInt(this.colIndex++) == 1;
                this.isMainScore = this.sql4javaSt.columnInt(this.colIndex++) == 1;
                this.scoreGUID = new PD_GUID(this.sql4javaSt.columnString(this.colIndex++));
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.processingNodeID = this.rs.getInt(this.colIndex++);
                this.scoreName = this.rs.getString(this.colIndex++);
                this.friendlyName = this.rs.getString(this.colIndex++);
                this.description = this.rs.getString(this.colIndex++);
                this.formatString = this.rs.getString(this.colIndex++);
                this.scoreCategory = this.rs.getInt(this.colIndex++);
                this.hidden = this.rs.getInt(this.colIndex++) == 1;
                this.isMainScore = this.rs.getInt(this.colIndex++) == 1;
                this.scoreGUID = new PD_GUID(this.rs.getString(this.colIndex++));
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    public long getScoreID() {
        return this.scoreID;
    }

    public int getProcessingNodeID() {
        return this.processingNodeID;
    }

    public String getScoreName() {
        return this.scoreName;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public int getScoreCategory() {
        return this.scoreCategory;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isMainScore() {
        return this.isMainScore;
    }

    public boolean isMascotScore() {
        return this.description.contains("Mascot");
    }

    public boolean isSEQUESTScore() {
        return this.description.contains("SEQUEST");
    }

    public boolean isZCoreScore() {
        return this.description.contains("ZCore");
    }

    public ProcessingNodes getProcessingNode() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.processingNode;
    }
}

