/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import de.mpc.BaseLib.GUID;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.CvtBaseLib.CVHelper;
import de.mpc.MzIdentML11Wrapper.CvParamCreator;
import de.mpc.PD.AminoAcidModifications;
import de.mpc.PD.FastaFiles;
import de.mpc.PD.FileInfos;
import de.mpc.PD.IPNNable;
import de.mpc.PD.PDBaseClassPairedPrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.Params.ParameterHandler;
import de.mpc.PD.ProcessingNodes;
import de.mpc.PD.SMsFromPNN;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProcessingNodeParameters
extends PDBaseClassPairedPrimaryKey
implements IPNNable {
    private final String STR_ION_SERIES_PURPOSE = "IonSeriesPurpose";
    private final String STR_MASCOT_PURPOSE = "MascotPurposeDetails";
    private final String STR_PEPTIDE_VALIDATION_PURPOSE = "PeptideValidationPurpose";
    private final String STR_SEQUEST_PURPOSE = "SequestPurposeDetails";
    private final String STR_PROTEIN = "Protein";
    private final String STR_LIKE_SM = "LIKE '%SEQUEST%' or FriendlyName LIKE '%Mascot%' OR FriendlyName Like '%ZCore%'";
    private static final String STR_MOD_MODIFICATION_DISPLAY_STRING = "([A-Za-z]*) / ([+]{1}[0-9]+.[0-9]*) ([A-Za-z]*) \\(([A-Z]{1})\\)";
    private static final String STR_DEFAULT_FDR_RATE_CALCULATOR = "DefaultFalseDiscoveryRateCalculator";
    private static final String STR_DYNMOD_1 = "DynMod_1";
    private static final String STR_DYNMOD_2 = "DynMod_2";
    private static final String STR_FASTA_DATABASE = "FastaDatabase";
    private static final String STR_FRAGMENT_TOLERANCE = "FragmentTolerance";
    private static final String STR_MAXIMUM_PRECURSOR_MASS = "MaximumPrecursorMass";
    private static final String STR_MINIMUM_PRECURSOR_MASS = "MinimumPrecursorMass";
    private static final String STR_PEPTIDE_TOLERANCE = "PeptideTolerance";
    private static final String STR_PRECURSOR_CLIPPING_RANGE_AFTER = "PrecursorClippigRangeAfter";
    private static final String STR_PRECURSOR_CLIPPING_RANGE_BEFORE = "PrecursorClippigRangeBefore";
    private static final String STR_SPECTRUM_FILENAMES = "SpectrumFileNames";
    private static final String STR_STATIC_X = "Static_X";
    private static final String STR_STATMOD_1 = "StatMod_1";
    private static final String STR_STATMOD_2 = "StatMod_2";
    private static final String STR_PREFIX_PROTEOME_DISCOVERER = "ProteomeDiscoverer:";
    private static final String STR_INFIX_PEPTIDE_VALIDATOR = "Peptide Validator:";
    private static final String STR_INFIX_PERCOLATOR = "Percolator:";
    private static final String STR_INFIX_SPECTRUM_EXPORTER = "Spectrum Exporter:";
    private static final String STR_INFIX_SPECTRUM_FILES = "Spectrum Files:";
    private static final String STR_INFIX_SPECTRUM_SELECTOR = "Spectrum Selector:";
    private static final String STR_INFIX_XTRACT = "Xtract:";
    private static final String STR_INFIX_SEQUEST = "SEQUEST:";
    private static final String STR_INFIX_MASCOT = "Mascot:";
    private static final String STR_INFIX_ZCORE = "ZCore:";
    private long processingNodeNumber = -1L;
    private final String parameterName;
    private String friendlyName;
    private int processingNodeID;
    private int intendedPurpose;
    private String purposeDetails;
    private boolean hidden;
    private boolean advanced;
    private String category;
    private int position;
    private String valueDisplayString;
    private String parameterValue;
    private static final ParameterHandler ph = new ParameterHandler(null);
    ArrayList<String> spectrumFileNamesList = new ArrayList();
    private ProcessingNodes processingNode = null;
    private final String searchMachine;

    public ProcessingNodeParameters(AProgramParameters pp, long processingNodeNo, String paramName) {
        super(pp);
        this.processingNodeNumber = processingNodeNo;
        this.parameterName = paramName;
        this.initFromDB();
        this.searchMachine = SMsFromPNN.retrieveSearchMachineForProcessingNodeNumber(pp, this.processingNodeNumber);
    }

    private void initFromDB() {
        this.sb.append("select FriendlyName, ProcessingNodeID, IntendedPurpose, PurposeDetails, Hidden, Advanced, Category, Position, ParameterValue, ValueDisplayString").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where ParameterName = ? and ProcessingNodeNumber = ?");
        this.initAndProcessPrepared(this.parameterName, this.getProcessingNodeNumber());
    }

    private void loadForeignKeyObjects() {
        if (this.processingNodeNumber > -1L && this.processingNode == null) {
            this.processingNode = this.requestProcessingNode(this.processingNodeNumber);
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private ProcessingNodes requestProcessingNode(long processingNodeNumber) {
        return new ProcessingNodes(this.getPP(), processingNodeNumber);
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.friendlyName = this.sql4javaSt.columnString(this.colIndex++);
                this.processingNodeID = this.sql4javaSt.columnInt(this.colIndex++);
                this.intendedPurpose = this.sql4javaSt.columnInt(this.colIndex++);
                this.purposeDetails = this.sql4javaSt.columnString(this.colIndex++);
                this.hidden = this.sql4javaSt.columnInt(this.colIndex++) == 1;
                this.advanced = this.sql4javaSt.columnInt(this.colIndex++) == 1;
                this.category = this.sql4javaSt.columnString(this.colIndex++);
                this.position = this.sql4javaSt.columnInt(this.colIndex++);
                this.parameterValue = this.sql4javaSt.columnString(this.colIndex++);
                this.valueDisplayString = this.sql4javaSt.columnString(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.friendlyName = this.rs.getString(this.colIndex++);
                this.processingNodeID = this.rs.getInt(this.colIndex++);
                this.intendedPurpose = this.rs.getInt(this.colIndex++);
                this.purposeDetails = this.rs.getString(this.colIndex++);
                this.hidden = this.rs.getInt(this.colIndex++) == 1;
                this.advanced = this.rs.getInt(this.colIndex++) == 1;
                this.category = this.rs.getString(this.colIndex++);
                this.position = this.rs.getInt(this.colIndex++);
                this.parameterValue = this.rs.getString(this.colIndex++);
                this.valueDisplayString = this.rs.getString(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public int getProcessingNodeID() {
        return this.processingNodeID;
    }

    public int getIntendedPurpose() {
        return this.intendedPurpose;
    }

    public String getPurposeDetails() {
        return this.purposeDetails;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean getAdvanced() {
        return this.advanced;
    }

    public String getCategory() {
        return this.category;
    }

    public int getPosition() {
        return this.position;
    }

    public String getParameterValue() {
        return this.parameterValue;
    }

    public String getValueDisplayString() {
        return this.valueDisplayString;
    }

    public ArrayList<String> getSpectrumFileNamesList() {
        if (this.parameterName.equals(STR_SPECTRUM_FILENAMES) && this.spectrumFileNamesList.isEmpty()) {
            String[] fileNames = this.valueDisplayString.split(MyConstants.STR_SEMICOLON);
            this.spectrumFileNamesList.addAll(Arrays.asList(fileNames));
        }
        return this.spectrumFileNamesList;
    }

    public String getCategoryNumberStr() {
        String match = "";
        if (this.startsWithNumber()) {
            Pattern pattern = Pattern.compile("^([0-9].[0-9]{0,1})");
            Matcher matcher = pattern.matcher(this.category);
            while (matcher.find()) {
                match = matcher.group(0);
            }
        }
        return match;
    }

    public String getCategoryString() {
        if (this.startsWithNumber()) {
            int pos = this.category.indexOf(32);
            return this.category.substring(pos + 1).trim();
        }
        return this.category;
    }

    private boolean startsWithNumber() {
        boolean bFoundPat = false;
        Pattern pattern = Pattern.compile("^[0-9].[0-9]{0,1}");
        Matcher matcher = pattern.matcher(this.category);
        while (matcher.find()) {
            bFoundPat = true;
        }
        return bFoundPat;
    }

    public boolean isIonSeriesPurpose() {
        return this.purposeDetails.startsWith("IonSeriesPurpose");
    }

    public boolean isMascotPurpose() {
        return this.purposeDetails.startsWith("MascotPurposeDetails");
    }

    public boolean isSequestPurpose() {
        return this.purposeDetails.startsWith("SequestPurposeDetails");
    }

    public boolean isPeptideValidationPurpose() {
        return this.purposeDetails.startsWith("PeptideValidationPurpose");
    }

    public boolean isProteinDetectionParameter() {
        return this.friendlyName.contains("Protein");
    }

    public boolean isSearchMachineSpecificParameter() {
        StringBuilder strB = new StringBuilder();
        strB.append("SELECT PNP.FriendlyName").append(MyConstants.newline);
        strB.append("FROM ProcessingNodeParameters AS PNP").append(MyConstants.newline);
        strB.append("WHERE ProcessingNodeNumber IN (").append(MyConstants.newline);
        strB.append("    SELECT ProcessingNodeNumber").append(MyConstants.newline);
        strB.append("    FROM ProcessingNodes AS PN").append(MyConstants.newline);
        strB.append("    WHERE PN.FriendlyName ").append("LIKE '%SEQUEST%' or FriendlyName LIKE '%Mascot%' OR FriendlyName Like '%ZCore%'").append(MyConstants.newline);
        strB.append("AND PNP.FriendlyName = ").append(this.friendlyName);
        String sqlStr = strB.toString();
        boolean bFoundParam = true;
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                SQLiteStatement sqlSt = this.getPP().getSQLiteAccess().dbConn.prepare(sqlStr);
                try {
                    while (sqlSt.step()) {
                        bFoundParam = true;
                    }
                }
                finally {
                    sqlSt.dispose();
                }
            }
            catch (SQLiteException sqliteex) {
                this.getPP().getSQLiteAccess().handleSQLite4JavaError(sqliteex);
                sqliteex.printStackTrace(System.err);
            }
        } else if (this.getPP().isUsingJDBC()) {
            try {
                Statement st = this.getPP().getJDBCAccess().dbConn.createStatement();
                this.rs = st.executeQuery(sqlStr);
                try {
                    while (this.rs.next()) {
                        bFoundParam = true;
                    }
                }
                finally {
                    st.close();
                }
            }
            catch (SQLException sex) {
                this.getPP().getJDBCAccess().handleJDBCError(sex);
                sex.printStackTrace(System.err);
            }
        }
        return bFoundParam;
    }

    public static boolean isObsoletedProteomeDiscovererCvTerm(String cvTerm) {
        return cvTerm.equals("Activation Type") || cvTerm.equals("Decoy Search") || cvTerm.equals("Enzyme Name") || cvTerm.equals("Export Format") || cvTerm.equals("Fragment Mass Tolerance") || cvTerm.equals("Highest MZ") || cvTerm.equals("Ionization Source") || cvTerm.equals("Lowest MZ") || cvTerm.equals("Mass Analyzer") || cvTerm.equals("Max RT Difference") || cvTerm.equals("MS Order") || cvTerm.equals("Organism") || cvTerm.equals("Polarity Mode") || cvTerm.equals("Precursor Mass Tolerance") || cvTerm.equals("Protein Database") || cvTerm.equals("Raw File names") || cvTerm.equals("Reference Database") || cvTerm.equals("Scan Type") || cvTerm.equals("Search Against Decoy Database") || cvTerm.equals("Source file extension") || cvTerm.equals("Source Files") || cvTerm.equals("Source Files old") || cvTerm.equals("SRF File Path") || cvTerm.equals("Taxonomy") || cvTerm.equals("Use Average Precursor Mass") || cvTerm.equals("use MudPIT scoring") || cvTerm.equals("User Name");
    }

    public static CvParamCreator translateDBParamNameToOBOName(String dbParamName) {
        String cvName;
        switch (dbParamName) {
            case "XCorrThreshold": 
            case "Absolute XCorr Threshold": {
                cvName = "ProteomeDiscoverer:SEQUEST:Absolute XCorr Threshold";
                break;
            }
            case "Activation Type": {
                cvName = "ionization type";
                break;
            }
            case "CalculateProbabilityScores": 
            case "Calculate Probability Scores": {
                cvName = "Calculate Probability Scores";
                break;
            }
            case "Default FDR Calculator": 
            case "DefaultFalseDiscoveryRateCalculator": {
                cvName = "ProteomeDiscoverer:Default FDR calculator";
                break;
            }
            case "Enzyme Name": 
            case "Enzyme": {
                cvName = "cleavage agent name";
                break;
            }
            case "Error tolerant Search": 
            case "ErrorTolerantSearch": {
                cvName = "ProteomeDiscoverer:Mascot:Error tolerant Search";
                break;
            }
            case "Export Format": {
                cvName = "mass spectrometer file format";
                break;
            }
            case "File Name(s)": 
            case "SpectrumFileNames": {
                cvName = "ProteomeDiscoverer:Spectrum Exporter:File Name(s)";
                break;
            }
            case "First Scan": 
            case "FirstScan": {
                cvName = "ProteomeDiscoverer:Spectrum Selector:First Scan";
                break;
            }
            case "Fragment Ion Cutoff Percentage": 
            case "IonCutoffPercent": {
                cvName = "ProteomeDiscoverer:SEQUEST:Fragment Ion Cutoff Percentage";
                break;
            }
            case "Fragment Mass Tolerance": 
            case "FragmentTolerance": {
                cvName = "search tolerance minus value";
                break;
            }
            case "Highest MZ": {
                cvName = "scan window upper limit";
                break;
            }
            case "Lowest MZ": {
                cvName = "scan window lower limit";
                break;
            }
            case "Highest Charge State": 
            case "HighestChargeState": {
                cvName = "ProteomeDiscoverer:Spectrum Selector:Highest Charge State";
                break;
            }
            case "Ionization Source": {
                cvName = "Mascot:inlet type";
                break;
            }
            case "Instrument": {
                cvName = "Mascot:Instrument";
                break;
            }
            case "LastScan": 
            case "Last Scan": {
                cvName = "ProteomeDiscoverer:Spectrum Selector:Last Scan";
                break;
            }
            case "LowResolutionSpectraContained": 
            case "Low resolution spectra contained": {
                cvName = "ProteomeDiscoverer:SEQUEST:Low resolution spectra contained";
                break;
            }
            case "LowerRetentionTimeLimit": 
            case "Lower RT Limit": {
                cvName = "ProteomeDiscoverer:Spectrum Selector:Lower RT Limit";
                break;
            }
            case "LowestChargeState": 
            case "Lowest Charge State": {
                cvName = "ProteomeDiscoverer:Spectrum Selector:Lowest Charge State";
                break;
            }
            case "Mascot Server URL": 
            case "MascotServerURL": {
                cvName = "ProteomeDiscoverer:Mascot:Mascot Server URL";
                break;
            }
            case "Mass Analyzer": {
                cvName = "mass analyzer type";
                break;
            }
            case "Max RT Difference": {
                cvName = "retention time window width";
                break;
            }
            case "Max. MGF File Size [MB]": 
            case "FileSize": {
                cvName = "ProteomeDiscoverer:Mascot:Max MGF File Size";
                break;
            }
            case "Max. Modifications Per Peptide": 
            case "MaxPTMPerPeptide": {
                cvName = "ProteomeDiscoverer:SEQUEST:Max. Modifications Per Peptide";
                break;
            }
            case "MaximumPrecursorMass": 
            case "Max. Precursor Mass": {
                cvName = "ProteomeDiscoverer:Spectrum Selector:Max. Precursor Mass";
                break;
            }
            case "Max. Delta Cn": {
                cvName = "ProteomeDiscoverer:Maximum Delta Cn";
                break;
            }
            case "Max. Equal Modifications Per Peptide": {
                cvName = "ProteomeDiscoverer:max equal modifications";
                break;
            }
            case "MissedCleavages": 
            case "Maximum Missed Cleavage Sites": 
            case "MaxMissedCleavages": 
            case "Max. Missed Cleavage Sites": {
                cvName = "ProteomeDiscoverer:Maximum Missed Cleavage Sites";
                break;
            }
            case "Maximum Peptides Considered": 
            case "MaxPeptidesConsidered": {
                cvName = "ProteomeDiscoverer:SEQUEST:Maximum Peptides Considered";
                break;
            }
            case "Maximum Peptides Output": 
            case "MaxPeptideEntries": {
                cvName = "ProteomeDiscoverer:SEQUEST:Maximum Peptides Output";
                break;
            }
            case "MaxProteinReferencesPerPeptide": 
            case "Maximum Protein References Per Peptide": {
                cvName = "ProteomeDiscoverer:SEQUEST:Maximum Protein References Per Peptide";
                break;
            }
            case "MinimumPrecursorMass": 
            case "Min. Precursor Mass": {
                cvName = "ProteomeDiscoverer:Spectrum Selector:Min. Precursor Mass";
                break;
            }
            case "Minimum Peak Count": 
            case "MinimumPeakCount": {
                cvName = "ProteomeDiscoverer:Minimum Peak Count";
                break;
            }
            case "MS Order": 
            case "MSOrderFilter": {
                cvName = "MSn spectrum";
                break;
            }
            case "Number of attempts to submit the search": 
            case "NumberOfSubmitAttemps": {
                cvName = "ProteomeDiscoverer:Mascot:Number of attempts to submit the search";
                break;
            }
            case "Organism": {
                cvName = "taxonomy: scientific name";
                break;
            }
            case "Peptide Cut Off Score": 
            case "PeptideCutOffScore": {
                cvName = "ProteomeDiscoverer:Mascot:Peptide Cut Off Score";
                break;
            }
            case "PeptideDeltaCutOffScore": 
            case "Peptide Relevance Factor": {
                cvName = "ProteomeDiscoverer:SEQUEST:Peptide Relevance Factor";
                break;
            }
            case "PeptidesWithoutProteinsCutOffScore": 
            case "Peptide Without Protein Cut Off Score": {
                cvName = "ProteomeDiscoverer:Mascot:Peptide Without Protein Cut Off Score";
                break;
            }
            case "Peptide Without Protein XCorr Threshold": {
                cvName = "ProteomeDiscoverer:SEQUEST:Peptide Without Protein XCorr Threshold";
                break;
            }
            case "Please Don't Touch this": {
                cvName = "ProteomeDiscoverer:Mascot:Please Do not Touch this";
                break;
            }
            case "Polarity Mode": {
                cvName = "scan polarity";
                break;
            }
            case "PrecursorClippigRangeAfter": 
            case "Precursor Clipping Range After": {
                cvName = "ProteomeDiscoverer:Spectrum Selector:Precursor Clipping Range After";
                break;
            }
            case "Precursor Clipping Range Before": 
            case "PrecursorClippigRangeBefore": {
                cvName = "ProteomeDiscoverer:Spectrum Selector:Precursor Clipping Range Before";
                break;
            }
            case "Precursor Mass Tolerance": 
            case "PeptideTolerance": {
                cvName = "search tolerance plus value";
                break;
            }
            case "Precursor Selection": 
            case "PrecursorSelectionStrategy": {
                cvName = "ProteomeDiscoverer:Spectrum Selector:Precursor Selection";
                break;
            }
            case "Reference Database": {
                cvName = "";
                break;
            }
            case "Protein Relevance Factor": 
            case "ProteinRelevanceFactor": {
                cvName = "ProteomeDiscoverer:Mascot:Protein Relevance Factor";
                break;
            }
            case "ProteinCutOffScore": 
            case "Protein Relevance Threshold": {
                cvName = "ProteomeDiscoverer:Mascot:Protein Relevance Threshold";
                break;
            }
            case "Protein Database": 
            case "FastaDatabase": 
            case "Database": {
                cvName = "database name";
                break;
            }
            case "Raw File names": {
                cvName = "mass spectrometer file format";
                break;
            }
            case "CutOffScore": {
                cvName = "ProteomeDiscoverer:SEQUEST:Protein Relevance Threshold";
                break;
            }
            case "DefaultRelaxedScoreThreshold": 
            case "Relaxed Score Threshold": {
                cvName = "ProteomeDiscoverer:Relaxed Score Threshold";
                break;
            }
            case "S/N Threshold (FT-only)": 
            case "SignalToNoiseThreshold": {
                cvName = "ProteomeDiscoverer:Spectrum Selector:S/N Threshold (FT-only)";
                break;
            }
            case "Scan Type": 
            case "ScanTypeFilter": {
                cvName = "ProteomeDiscoverer:Scan Type";
                break;
            }
            case "UseDecoyDatabase": 
            case "DecoySearch": 
            case "Search Against Decoy Database": {
                cvName = "quality estimation with decoy database";
                break;
            }
            case "Search Modifications Only For Identified Proteins": 
            case "SearchModificationsOnlyInDeepSearch": {
                cvName = "ProteomeDiscoverer:SEQUEST:Search Modifications Only For Identified Proteins";
                break;
            }
            case "SignificanceHigh": 
            case "Significance High": {
                cvName = "ProteomeDiscoverer:Mascot:Significance High";
                break;
            }
            case "Significance Middle": 
            case "SignificanceMiddle": {
                cvName = "ProteomeDiscoverer:Mascot:Significance Middle";
                break;
            }
            case "SRF File Path": {
                cvName = "";
                break;
            }
            case "Static_X": 
            case "Static Modification for X": {
                cvName = "ProteomeDiscoverer:SEQUEST:Static Modification for X";
                break;
            }
            case "DefaultStrictScoreThreshold": 
            case "Strict Score Threshold": {
                cvName = "ProteomeDiscoverer:Strict Score Threshold";
                break;
            }
            case "TargetFPRMiddle": 
            case "Target FDR (Relaxed)": {
                cvName = "ProteomeDiscoverer:Peptide Validator:Target FDR (Relaxed)";
                break;
            }
            case "Target FDR (Strict)": 
            case "TargetFPRHigh": {
                cvName = "ProteomeDiscoverer:Peptide Validator:Target FDR (Strict)";
                break;
            }
            case "Taxonomy": {
                cvName = "taxonomy: scientific name";
                break;
            }
            case "SubsequentSearchSubmitTimeInterval": 
            case "Time interval between attempts to submit a search [sec]": {
                cvName = "ProteomeDiscoverer:Mascot:Time interval between attempts to submit a search";
                break;
            }
            case "Source file extension": {
                cvName = "mass spectrometer file format";
                break;
            }
            case "Source Files": {
                cvName = "pepXML file";
                break;
            }
            case "Source Files old": {
                cvName = "pepXML file";
                break;
            }
            case "Total Intensity Threshold": 
            case "TotalIntensityThreshold": {
                cvName = "ProteomeDiscoverer:Total Intensity Threshold";
                break;
            }
            case "UnrecognizedActivationTypeReplacement": 
            case "Unrecognized Activation Type Replacements": {
                cvName = "ProteomeDiscoverer:Spectrum Selector:Unrecognized Activation Type Replacements";
                break;
            }
            case "UnrecognizedChargeReplacements": 
            case "Unrecognized Charge Replacements": {
                cvName = "ProteomeDiscoverer:Spectrum Selector:Unrecognized Charge Replacements";
                break;
            }
            case "UnrecognizedMassAnalyzerReplacement": 
            case "Unrecognized Mass Analyzer Replacements": {
                cvName = "ProteomeDiscoverer:Spectrum Selector:Unrecognized Mass Analyzer Replacements";
                break;
            }
            case "Unrecognized MS Order Replacements": 
            case "UnrecognizedMsOrderReplacement": {
                cvName = "ProteomeDiscoverer:Spectrum Selector:Unrecognized MS Order Replacements";
                break;
            }
            case "UnrecognizedPolarityTypeReplacement": 
            case "Unrecognized Polarity Replacements": {
                cvName = "ProteomeDiscoverer:Spectrum Selector:Unrecognized Polarity Replacements";
                break;
            }
            case "Upper RT Limit": 
            case "UpperRetentionTimeLimit": {
                cvName = "ProteomeDiscoverer:Spectrum Selector:Upper RT Limit";
                break;
            }
            case "Use Average Fragment Mass": 
            case "Use Average Fragment Masses": 
            case "UseAverageFragmentMass": {
                cvName = "ProteomeDiscoverer:SEQUEST:Use Average Fragment Masses";
                break;
            }
            case "UseAveragePrecursorMass": 
            case "Use Average Precursor Mass": {
                cvName = "parent mass type average";
                break;
            }
            case "Use Flanking Ions": {
                cvName = "ProteomeDiscoverer:SEQUEST:use flanking ions";
                break;
            }
            case "UseMudPitScoring": 
            case "Use MudPIT Scoring": {
                String cvName2 = "Mascot:ProteinScoringMethod";
                CvParamCreator cpc = ph.getCvParamCreatorForCvTerm(cvName2, "MS");
                cpc.setValue("MudPIT");
                CVHelper.testCVConsistency((CvParamCreator)cpc, (String)"translateDBParamNameToOBOName - 1");
                return cpc;
            }
            case "Use Neutral Loss A Ions": 
            case "Use Neutral Loss a Ions": 
            case "UseNeutralAIons": {
                cvName = "ProteomeDiscoverer:Use Neutral Loss a Ions";
                break;
            }
            case "Use Neutral Loss B Ions": 
            case "Use Neutral Loss b Ions": 
            case "UseNeutralBIons": {
                cvName = "ProteomeDiscoverer:Use Neutral Loss b Ions";
                break;
            }
            case "Use Neutral Loss Y Ions": 
            case "Use Neutral Loss y Ions": 
            case "UseNeutralYIons": {
                cvName = "ProteomeDiscoverer:Use Neutral Loss y Ions";
                break;
            }
            case "Use Neutral Loss Z Ions": 
            case "UseNeutralZIons": {
                cvName = "ProteomeDiscoverer:Use Neutral Loss z Ions";
                break;
            }
            case "Use New Precursor Reevaluation": 
            case "UseNewPrecursorPeakReevaluation": {
                cvName = "ProteomeDiscoverer:Spectrum Selector:Use New Precursor Reevaluation";
                break;
            }
            case "User Name": 
            case "Username": {
                cvName = "researcher";
                break;
            }
            case "UsernameWebServer": 
            case "Weight of a Ions": {
                cvName = "ProteomeDiscoverer:SEQUEST:Weight of a Ions";
                break;
            }
            case "Weight of A Ions": {
                cvName = "ProteomeDiscoverer:Mascot:Weight of A Ions";
                break;
            }
            case "Weight of b Ions": {
                cvName = "ProteomeDiscoverer:SEQUEST:Weight of b Ions";
                break;
            }
            case "Weight of B Ions": {
                cvName = "ProteomeDiscoverer:Mascot:Weight of B Ions";
                break;
            }
            case "Weight of C Ions": {
                cvName = "ProteomeDiscoverer:Mascot:Weight of C Ions";
                break;
            }
            case "Weight of c Ions": {
                cvName = "ProteomeDiscoverer:SEQUEST:Weight of c Ions";
                break;
            }
            case "Weight of D Ions": {
                cvName = "ProteomeDiscoverer:Mascot:Weight of D Ions";
                break;
            }
            case "Weight of d Ions": {
                cvName = "ProteomeDiscoverer:SEQUEST:Weight of d Ions";
                break;
            }
            case "Weight of V Ions": {
                cvName = "ProteomeDiscoverer:Mascot:Weight of V Ions";
                break;
            }
            case "Weight of v Ions": {
                cvName = "ProteomeDiscoverer:SEQUEST:Weight of v Ions";
                break;
            }
            case "Weight of W Ions": {
                cvName = "ProteomeDiscoverer:Mascot:Weight of W Ions";
                break;
            }
            case "Weight of w Ions": {
                cvName = "ProteomeDiscoverer:SEQUEST:Weight of w Ions";
                break;
            }
            case "Weight of X Ions": {
                cvName = "ProteomeDiscoverer:Mascot:Weight of X Ions";
                break;
            }
            case "Weight of x Ions": {
                cvName = "ProteomeDiscoverer:SEQUEST:Weight of x Ions";
                break;
            }
            case "Weight of y Ions": {
                cvName = "ProteomeDiscoverer:SEQUEST:Weight of y Ions";
                break;
            }
            case "Weight of Y Ions": {
                cvName = "ProteomeDiscoverer:Mascot:Weight of Y Ions";
                break;
            }
            case "Weight of Z Ions": {
                cvName = "ProteomeDiscoverer:Mascot:Weight of Z Ions";
                break;
            }
            case "Weight of z Ions": {
                cvName = "ProteomeDiscoverer:SEQUEST:Weight of z Ions";
                break;
            }
            case "X Static Modification": {
                cvName = "ProteomeDiscoverer:Mascot:X Static Modification";
                break;
            }
            case "CutOffFTCharge1High": {
                cvName = "ProteomeDiscoverer:SEQUEST:FT High Confidence XCorr Charge1";
                break;
            }
            case "CutOffStdCharge1High": 
            case "z=1: High Confidence XCorr": {
                cvName = "ProteomeDiscoverer:SEQUEST:Std High Confidence XCorr Charge1";
                break;
            }
            case "CutOffFTCharge1Middle": {
                cvName = "ProteomeDiscoverer:SEQUEST:FT Medium Confidence XCorr Charge1";
                break;
            }
            case "CutOffStdCharge1Middle": 
            case "z=1: Medium Confidence XCorr": {
                cvName = "ProteomeDiscoverer:SEQUEST:Std Medium Confidence XCorr Charge1";
                break;
            }
            case "CutOffFTCharge2High": {
                cvName = "ProteomeDiscoverer:SEQUEST:FT High Confidence XCorr Charge2";
                break;
            }
            case "CutOffStdCharge2High": 
            case "z=2: High Confidence XCorr": {
                cvName = "ProteomeDiscoverer:SEQUEST:Std High Confidence XCorr Charge2";
                break;
            }
            case "CutOffFTCharge2Middle": {
                cvName = "ProteomeDiscoverer:SEQUEST:FT Medium Confidence XCorr Charge2";
                break;
            }
            case "z=2: Medium Confidence XCorr": 
            case "CutOffStdCharge2Middle": {
                cvName = "ProteomeDiscoverer:SEQUEST:Std Medium Confidence XCorr Charge2";
                break;
            }
            case "CutOffFTCharge3High": {
                cvName = "ProteomeDiscoverer:SEQUEST:FT High Confidence XCorr Charge3";
                break;
            }
            case "CutOffStdCharge3High": 
            case "z=3: High Confidence XCorr": {
                cvName = "ProteomeDiscoverer:SEQUEST:Std High Confidence XCorr Charge3";
                break;
            }
            case "CutOffFTCharge3Middle": {
                cvName = "ProteomeDiscoverer:SEQUEST:FT Medium Confidence XCorr Charge3";
                break;
            }
            case "z=3: Medium Confidence XCorr": 
            case "CutOffStdCharge3Middle": {
                cvName = "ProteomeDiscoverer:SEQUEST:Std Medium Confidence XCorr Charge3";
                break;
            }
            case "CutOffFTCharge4High": {
                cvName = "ProteomeDiscoverer:SEQUEST:FT High Confidence XCorr Charge4";
                break;
            }
            case "z>=4: High Confidence XCorr": 
            case "CutOffStdCharge4High": {
                cvName = "ProteomeDiscoverer:SEQUEST:Std High Confidence XCorr Charge4";
                break;
            }
            case "CutOffFTCharge4Middle": {
                cvName = "ProteomeDiscoverer:SEQUEST:FT Medium Confidence XCorr Charge4";
                break;
            }
            case "CutOffStdCharge4Middle": 
            case "z>=4: Medium Confidence XCorr": {
                cvName = "ProteomeDiscoverer:SEQUEST:Std Medium Confidence XCorr Charge4";
                break;
            }
            default: {
                statLogger.warn("Parameter name '{}' from the database not translated into a corresponding OBO term.", (Object)dbParamName);
                return null;
            }
        }
        CvParamCreator cpc = ph.getCvParamCreatorForCvTerm(cvName, "MS");
        CVHelper.testCVConsistency((CvParamCreator)cpc, (String)"translateDBParamNameToOBOName- 2");
        return cpc;
    }

    public boolean hasUnit() {
        return this.parameterName.equals(STR_DYNMOD_1) || this.parameterName.equals(STR_DYNMOD_2) || this.parameterName.equals(STR_STATMOD_1) || this.parameterName.equals(STR_STATMOD_2) || this.parameterName.equals(STR_FRAGMENT_TOLERANCE) || this.parameterName.equals(STR_MAXIMUM_PRECURSOR_MASS) || this.parameterName.equals(STR_MINIMUM_PRECURSOR_MASS) || this.parameterName.equals(STR_PEPTIDE_TOLERANCE) || this.parameterName.equals(STR_PRECURSOR_CLIPPING_RANGE_AFTER) || this.parameterName.equals(STR_PRECURSOR_CLIPPING_RANGE_BEFORE) || this.parameterName.equals(STR_STATIC_X);
    }

    public String getUnit() {
        if (this.hasUnit()) {
            if (this.parameterName.equals(STR_DYNMOD_1) || this.parameterName.equals(STR_DYNMOD_2) || this.parameterName.equals(STR_STATMOD_1) || this.parameterName.equals(STR_STATMOD_2) || this.parameterName.equals(STR_STATIC_X)) {
                int pos = this.parameterValue.lastIndexOf(32);
                return this.parameterValue.substring(pos + 1);
            }
            String unitStr = "";
            Pattern pattern = Pattern.compile(STR_MOD_MODIFICATION_DISPLAY_STRING);
            Matcher matcher = pattern.matcher(this.parameterValue);
            while (matcher.find()) {
                unitStr = matcher.group(3);
            }
            return unitStr;
        }
        statLogger.warn("Parameter {} has no unit.", (Object)this.parameterValue);
        return "";
    }

    public static String getModificationNameFromDisplayString(String displayString) {
        String modificationName = "";
        Pattern pattern = Pattern.compile(STR_MOD_MODIFICATION_DISPLAY_STRING);
        Matcher matcher = pattern.matcher(displayString);
        while (matcher.find()) {
            modificationName = matcher.group(1);
        }
        return modificationName;
    }

    public static float getMassDeltaFromDisplayString(String displayString) {
        String massDeltaStr = "";
        Pattern pattern = Pattern.compile(STR_MOD_MODIFICATION_DISPLAY_STRING);
        Matcher matcher = pattern.matcher(displayString);
        while (matcher.find()) {
            massDeltaStr = matcher.group(2);
        }
        return Float.parseFloat(massDeltaStr);
    }

    public static char getResidueFromDisplayString(String displayString) {
        char chResidue = ' ';
        Pattern pattern = Pattern.compile(STR_MOD_MODIFICATION_DISPLAY_STRING);
        Matcher matcher = pattern.matcher(displayString);
        while (matcher.find()) {
            chResidue = matcher.group(4).toCharArray()[0];
        }
        return chResidue;
    }

    public GUID getGUIDValue() {
        if (this.parameterName.equals(STR_DEFAULT_FDR_RATE_CALCULATOR)) {
            return new GUID(this.parameterValue);
        }
        statLogger.error("Parameter {} has no GUID value.", (Object)this.parameterValue);
        return new GUID("");
    }

    public AminoAcidModifications getIndexedObject() {
        if (this.parameterName.equals(STR_DYNMOD_1) || this.parameterName.equals(STR_DYNMOD_2) || this.parameterName.equals(STR_STATMOD_1) || this.parameterName.equals(STR_STATMOD_2) || this.parameterName.equals(STR_STATIC_X)) {
            int pos = this.parameterName.indexOf(35);
            return new AminoAcidModifications(this.getPP(), Long.parseLong(this.parameterValue.substring(pos + 1)));
        }
        this.logger.error("Parameter {} has no AminoAcidModifications value.", (Object)this.parameterValue);
        return null;
    }

    public FastaFiles getFastaFilesObj() {
        if (this.parameterName.equals(STR_FASTA_DATABASE)) {
            return new FastaFiles(this.getPP(), Long.parseLong(this.parameterValue));
        }
        this.logger.error("Parameter {} has no FastaFiles value.", (Object)this.parameterValue);
        return null;
    }

    public ArrayList<FileInfos> getFileInfoList() {
        ArrayList<FileInfos> fileInfoList = new ArrayList<FileInfos>();
        if (this.parameterName.equals(STR_SPECTRUM_FILENAMES)) {
            String[] ids;
            String[] stringArray = ids = this.parameterValue.split(MyConstants.STR_SEMICOLON);
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String idStr = stringArray[n2];
                fileInfoList.add(new FileInfos(this.getPP(), Long.parseLong(idStr)));
                ++n2;
            }
        } else {
            this.logger.error("Parameter {} has no FileInfos list value.", (Object)this.parameterValue);
        }
        return fileInfoList;
    }

    @Override
    public long getProcessingNodeNumber() {
        return this.processingNodeNumber;
    }

    @Override
    public ProcessingNodes getProcessingNode() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.processingNode;
    }

    @Override
    public String getSearchMachine() {
        return this.searchMachine;
    }
}

