/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.PDBaseClass;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.ProcessingNodes;
import java.sql.SQLException;

public class ProcessingNodeInterfaces
extends PDBaseClass {
    private long processingNodeID = -1L;
    private String interfaceName = "";
    private InterfaceKind interfaceKind;
    private ProcessingNodes processingNode = null;

    public ProcessingNodeInterfaces(AProgramParameters pp, long processingNodeID, String interfaceName) {
        super(pp);
        this.processingNodeID = processingNodeID;
        this.interfaceName = interfaceName;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select InterfaceKind").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where ProcessingNodeID = ? and InterfaceName = ?");
        this.initAndProcessPreparedIDStr(this.processingNodeID, this.interfaceName);
    }

    private void loadForeignKeyObjects() {
        if (this.processingNodeID > -1L && this.processingNode == null) {
            this.processingNode = this.requestProcessingNode(this.processingNodeID);
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private ProcessingNodes requestProcessingNode(long processingNodeID) {
        return new ProcessingNodes(this.getPP(), processingNodeID);
    }

    @Override
    protected final void setAllMembers() {
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.interfaceKind = InterfaceKind.fromStringValue(this.sql4javaSt.columnString(0));
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.interfaceKind = InterfaceKind.fromStringValue(this.rs.getString(1));
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    public long getProcessingNodeID() {
        return this.processingNodeID;
    }

    public InterfaceKind getInterfaceKind() {
        return this.interfaceKind;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public ProcessingNodes getProcessingNode() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.processingNode;
    }

    public static enum InterfaceKind {
        UNKNOWN(-1),
        SINK(0),
        SOURCE(1),
        PROCESSING(2);

        private final int interfaceKind;

        private InterfaceKind(int interfaceKind) {
            this.interfaceKind = interfaceKind;
        }

        public int getInterfaceKindCode() {
            return this.interfaceKind;
        }

        public static InterfaceKind fromStringValue(String valStr) {
            switch (Integer.parseInt(valStr)) {
                case 0: {
                    return SINK;
                }
                case 1: {
                    return SOURCE;
                }
                case 2: {
                    return PROCESSING;
                }
            }
            return UNKNOWN;
        }
    }
}

