/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.IPNNable;
import de.mpc.PD.PDBaseClassPairedPrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.ProcessingNodes;
import de.mpc.PD.SMsFromPNN;
import java.sql.SQLException;

public class ProcessingNodeFilterParameters
extends PDBaseClassPairedPrimaryKey
implements IPNNable {
    private long processingNodeNumber = -1L;
    private final String filterParameterName;
    private long filterModuleTypeID;
    private int filterModuleNumber;
    private long processingNodeID;
    private double filterParameterValue;
    private ProcessingNodes processingNode = null;
    private final String searchMachine;

    public ProcessingNodeFilterParameters(AProgramParameters pp, long processingNodeNo, String filterParameterName) {
        super(pp);
        this.processingNodeNumber = processingNodeNo;
        this.filterParameterName = filterParameterName;
        this.initFromDB();
        this.searchMachine = SMsFromPNN.retrieveSearchMachineForProcessingNodeNumber(pp, this.processingNodeNumber);
    }

    private void initFromDB() {
        this.sb.append("select FilterModuleTypeID, FilterModuleNumber, ProcessingNodeID, FilterParameterValue").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where FilterParameterName = ? and ProcessingNodeNumber = ?");
        this.initAndProcessPrepared(this.filterParameterName, this.getProcessingNodeNumber());
    }

    private void loadForeignKeyObjects() {
        if (this.processingNodeNumber > -1L && this.processingNode == null) {
            this.processingNode = this.requestProcessingNode(this.processingNodeNumber);
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private ProcessingNodes requestProcessingNode(long processingNodeNumber) {
        return new ProcessingNodes(this.getPP(), processingNodeNumber);
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.filterModuleTypeID = this.sql4javaSt.columnLong(this.colIndex++);
                this.filterModuleNumber = this.sql4javaSt.columnInt(this.colIndex++);
                this.processingNodeID = this.sql4javaSt.columnLong(this.colIndex++);
                this.filterParameterValue = this.sql4javaSt.columnDouble(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.filterModuleTypeID = this.rs.getLong(this.colIndex++);
                this.filterModuleNumber = this.rs.getInt(this.colIndex++);
                this.processingNodeID = this.rs.getLong(this.colIndex++);
                this.filterParameterValue = this.rs.getDouble(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    public String getFilterParameterName() {
        return this.filterParameterName;
    }

    public long getFilterModuleTypeID() {
        return this.filterModuleTypeID;
    }

    public int getFilterModuleNumber() {
        return this.filterModuleNumber;
    }

    public long getProcessingNodeID() {
        return this.processingNodeID;
    }

    public double getFilterParameterValue() {
        return this.filterParameterValue;
    }

    @Override
    public long getProcessingNodeNumber() {
        return this.processingNodeNumber;
    }

    @Override
    public ProcessingNodes getProcessingNode() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.processingNode;
    }

    @Override
    public String getSearchMachine() {
        return this.searchMachine;
    }
}

