/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.FDRSettings.FalseDiscoveryRateSettingsType;
import de.mpc.PD.IPNNable;
import de.mpc.PD.IVersionable;
import de.mpc.PD.PDBaseClassSinglePrimaryKey;
import de.mpc.PD.PD_GUID;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.ProcessingNodes;
import de.mpc.PD.SMsFromPNN;
import de.mpc.PD.XML.FDRSettingsSaxParser;
import java.sql.SQLException;

public class ProcessingNodeExtensions
extends PDBaseClassSinglePrimaryKey
implements IPNNable,
IVersionable {
    private long extensionID = -1L;
    private long processingNodeNumber = -1L;
    private PD_GUID guid = null;
    private String purpose;
    private String purposeDetail;
    private int majorVersion;
    private int minorVersion;
    private String settingsXMLStr;
    private ProcessingNodes processingNode = null;
    private final String searchMachine;

    public ProcessingNodeExtensions(AProgramParameters pp, long extensionID) {
        super(pp);
        this.extensionID = extensionID;
        this.initFromDB();
        this.searchMachine = SMsFromPNN.retrieveSearchMachineForProcessingNodeNumber(pp, this.processingNodeNumber);
    }

    private void initFromDB() {
        this.sb.append("select ProcessingNodeNumber, Guid, Purpose, PurposeDetail, MajorVersion, MinorVersion, Settings").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where ExtensionID = ?");
        this.initAndProcessPrepared(this.extensionID);
    }

    private void loadGUIDObjects() {
        if (this.guid != null) assert (this.isNotNull((Object)this.guid));
        this.bGUIDObjectsLoaded = true;
    }

    private void loadForeignKeyObjects() {
        if (this.processingNodeNumber > -1L && this.processingNode == null) {
            this.processingNode = this.requestProcessingNode(this.processingNodeNumber);
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private ProcessingNodes requestProcessingNode(long processingNodeNumber) {
        return new ProcessingNodes(this.getPP(), processingNodeNumber);
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.processingNodeNumber = this.sql4javaSt.columnInt(this.colIndex++);
                this.guid = new PD_GUID(this.sql4javaSt.columnString(this.colIndex++));
                this.purpose = this.sql4javaSt.columnString(this.colIndex++);
                this.purposeDetail = this.sql4javaSt.columnString(this.colIndex++);
                this.majorVersion = this.sql4javaSt.columnInt(this.colIndex++);
                this.minorVersion = this.sql4javaSt.columnInt(this.colIndex++);
                this.settingsXMLStr = this.sql4javaSt.columnString(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.processingNodeNumber = this.rs.getInt(this.colIndex++);
                this.guid = new PD_GUID(this.rs.getString(this.colIndex++));
                this.purpose = this.rs.getString(this.colIndex++);
                this.purposeDetail = this.rs.getString(this.colIndex++);
                this.majorVersion = this.rs.getInt(this.colIndex++);
                this.minorVersion = this.rs.getInt(this.colIndex++);
                this.settingsXMLStr = this.rs.getString(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    public long getExtensionID() {
        return this.extensionID;
    }

    public PD_GUID getGuid() {
        return this.guid;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public String getPurposeDetail() {
        return this.purposeDetail;
    }

    @Override
    public int getMajorVersion() {
        return this.majorVersion;
    }

    @Override
    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String getSettingsXMLStr() {
        return this.settingsXMLStr;
    }

    public FalseDiscoveryRateSettingsType getFDRSettings() {
        FDRSettingsSaxParser fdrSettingsParser = new FDRSettingsSaxParser(this.settingsXMLStr);
        return fdrSettingsParser.getFDRSettings();
    }

    @Override
    public String getVersion() {
        StringBuilder strB = new StringBuilder(this.majorVersion);
        strB.append('.');
        strB.append(this.minorVersion);
        return strB.toString();
    }

    public FalseDiscoveryRateSettingsType getFilterInfoSet() {
        FDRSettingsSaxParser parser = new FDRSettingsSaxParser(this.getSettingsXMLStr());
        return parser.getFDRSettings();
    }

    @Override
    public long getProcessingNodeNumber() {
        return this.processingNodeNumber;
    }

    @Override
    public ProcessingNodes getProcessingNode() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.processingNode;
    }

    @Override
    public String getSearchMachine() {
        return this.searchMachine;
    }
}

