/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.PDBaseClass;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.ProcessingNodeInterfaces;
import de.mpc.PD.ProcessingNodes;
import java.sql.SQLException;

public class ProcessingNodeConnectionPoints
extends PDBaseClass {
    private long processingNodeID = -1L;
    private final String interfaceStr;
    private ConnectionDirection connectionDirection;
    private int connectionMode;
    private int connectionMultiplicity;
    private int connectionRequirement;
    private String dataTypeSpecialization;
    private String connectionDisplayName;
    private ProcessingNodeInterfaces processingNodeInterface = null;
    private ProcessingNodes processingNode = null;

    public ProcessingNodeConnectionPoints(AProgramParameters pp, long processingNodeID, String ifaceStr) {
        super(pp);
        this.processingNodeID = processingNodeID;
        this.interfaceStr = ifaceStr;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select ConnectionDirection, ConnectionMode, ConnectionMultiplicity, ConnectionRequirement, DataTypeSpecialization, ConnectionDisplayName").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where ProcessingNodeID = ? and Interface = ?");
        this.initAndProcessPreparedIDStr(this.processingNodeID, this.interfaceStr);
    }

    private void loadForeignKeyObjects() {
        if (!this.interfaceStr.isEmpty() && this.processingNodeInterface == null) {
            this.processingNodeInterface = this.requestProcessingNodeInterface(this.interfaceStr);
        }
        if (this.processingNodeID > -1L && this.processingNode == null) {
            this.processingNode = this.requestProcessingNode(this.processingNodeID);
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private ProcessingNodeInterfaces requestProcessingNodeInterface(String interfaceStr) {
        return new ProcessingNodeInterfaces(this.getPP(), this.processingNodeID, interfaceStr);
    }

    private ProcessingNodes requestProcessingNode(long processingNodeID) {
        return new ProcessingNodes(this.getPP(), processingNodeID);
    }

    @Override
    protected final void setAllMembers() {
        if (this.getPP().isUsingSQLite4Java()) {
            this.colIndex = 2;
            try {
                this.connectionDirection = ConnectionDirection.fromStringValue(this.sql4javaSt.columnString(this.colIndex++));
                this.connectionMode = this.sql4javaSt.columnInt(this.colIndex++);
                this.connectionMultiplicity = this.sql4javaSt.columnInt(this.colIndex++);
                this.connectionRequirement = this.sql4javaSt.columnInt(this.colIndex++);
                this.dataTypeSpecialization = this.sql4javaSt.columnString(this.colIndex++);
                this.connectionDisplayName = this.sql4javaSt.columnString(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            this.colIndex = 3;
            try {
                this.connectionDirection = ConnectionDirection.fromStringValue(this.rs.getString(this.colIndex++));
                this.connectionMode = this.rs.getInt(this.colIndex++);
                this.connectionMultiplicity = this.rs.getInt(this.colIndex++);
                this.connectionRequirement = this.rs.getInt(this.colIndex++);
                this.dataTypeSpecialization = this.rs.getString(this.colIndex++);
                this.connectionDisplayName = this.rs.getString(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    public long getProcessingNodeID() {
        return this.processingNodeID;
    }

    public String getInterface() {
        return this.interfaceStr;
    }

    public ConnectionDirection getConnectionDirection() {
        return this.connectionDirection;
    }

    public int getConnectionMode() {
        return this.connectionMode;
    }

    public int getConnectionMultiplicity() {
        return this.connectionMultiplicity;
    }

    public int getConnectionRequirement() {
        return this.connectionRequirement;
    }

    public String getDataTypeSpecialization() {
        return this.dataTypeSpecialization;
    }

    public String getConnectionDisplayName() {
        return this.connectionDisplayName;
    }

    public ProcessingNodeInterfaces getProcessingNodeInterface() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.processingNodeInterface;
    }

    public ProcessingNodes getProcessingNode() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.processingNode;
    }

    public static enum ConnectionDirection {
        UNKNOWN(-1),
        SOURCE(0),
        SINK(1);

        private final int connectionDirection;

        private ConnectionDirection(int connDir) {
            this.connectionDirection = connDir;
        }

        public int getConnectionDirectionCode() {
            return this.connectionDirection;
        }

        public static ConnectionDirection fromStringValue(String valStr) {
            switch (Integer.parseInt(valStr)) {
                case 0: {
                    return SOURCE;
                }
                case 1: {
                    return SINK;
                }
            }
            return UNKNOWN;
        }
    }
}

