/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.AIonQuanResultsSearchSpectra;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.QuanResults;
import java.sql.SQLException;

public class PrecursorIonQuanResultsSearchSpectra
extends AIonQuanResultsSearchSpectra {
    private long quanResultID = -1L;
    private QuanResults quanResult = null;

    public PrecursorIonQuanResultsSearchSpectra(AProgramParameters pp, long processingNodeNumber, long quanResultID, long searchSpectrumID) {
        super(pp, processingNodeNumber);
        this.processingNodeNumber = processingNodeNumber;
        this.quanResultID = quanResultID;
        this.searchSpectrumID = searchSpectrumID;
        this.initFromDB();
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.quanResultID = this.sql4javaSt.columnLong(this.colIndex++);
                this.searchSpectrumID = this.sql4javaSt.columnLong(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.quanResultID = this.rs.getLong(this.colIndex++);
                this.searchSpectrumID = this.rs.getLong(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    private void initFromDB() {
        this.sb.append("select QuanResultID, SearchSpectrumID").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where ProcessingNodeNumber = ? and QuanResultID = ?");
        this.initAndProcessPrepared(this.getProcessingNodeNumber(), this.quanResultID);
    }

    @Override
    protected final void loadForeignKeyObjects() {
        super.loadForeignKeyObjects();
        if (this.quanResultID > -1L && this.quanResult == null) {
            this.quanResult = this.requestQuanResult(this.quanResultID);
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private QuanResults requestQuanResult(long quanResID) {
        return new QuanResults(this.getPP(), quanResID, this.searchSpectrumID);
    }

    public QuanResults getQuanResult() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.quanResult;
    }
}

