/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.IMZable;
import de.mpc.PD.PDBaseClassPairedPrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.QuanResults;
import java.sql.SQLException;
import java.util.ArrayList;

public class PrecursorIonQuanResults
extends PDBaseClassPairedPrimaryKey
implements IMZable {
    private long quanChannelID = -1L;
    private long quanResultID = -1L;
    private double mass;
    private int charge;
    private double area;
    private double retentionTime;
    private final ArrayList<QuanResults> quanResultsList = new ArrayList();

    public PrecursorIonQuanResults(AProgramParameters pp, long quanChannelID, long quanResultID) {
        super(pp);
        this.quanChannelID = quanChannelID;
        this.quanResultID = quanResultID;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select Mass, Charge, Area, RetentionTime").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where QuanChannelID = ? and QuanResultID = ?");
        this.initAndProcessPrepared(this.quanChannelID, this.quanResultID);
    }

    private void loadForeignKeyObjects() {
        if (this.quanResultID > -1L) {
            this.requestQuanResultsList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private void requestQuanResultsList() {
        for (Object obj : QuanResults.getObjectIDList(this.getPP(), QuanResults.class)) {
            if (((QuanResults)obj).getQuanResultID() != this.quanResultID) continue;
            this.quanResultsList.add((QuanResults)obj);
        }
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.mass = this.sql4javaSt.columnDouble(this.colIndex++);
                this.charge = this.sql4javaSt.columnInt(this.colIndex++);
                this.area = this.sql4javaSt.columnDouble(this.colIndex++);
                this.retentionTime = this.sql4javaSt.columnDouble(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.mass = this.rs.getDouble(this.colIndex++);
                this.charge = this.rs.getInt(this.colIndex++);
                this.area = this.rs.getDouble(this.colIndex++);
                this.retentionTime = this.rs.getDouble(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    public long getQuanChannelID() {
        return this.quanChannelID;
    }

    public long getQuanResultID() {
        return this.quanResultID;
    }

    public double getMass() {
        return this.mass;
    }

    public int getCharge() {
        return this.charge;
    }

    public double getArea() {
        return this.area;
    }

    public double getRetentionTime() {
        return this.retentionTime;
    }

    @Override
    public float getMz() {
        if (this.charge != 0) {
            return (float)(this.mass / (double)this.charge);
        }
        return Float.POSITIVE_INFINITY;
    }

    public ArrayList<QuanResults> getQuanResultsList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.quanResultsList;
    }
}

