/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.PDBaseClassSinglePrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.QuanResults;
import java.sql.SQLException;
import java.util.ArrayList;

public class PrecursorIonAreaSearchSpectra
extends PDBaseClassSinglePrimaryKey {
    private long quanResultID = -1L;
    private QuanResults quanResult = null;
    private final ArrayList<QuanResults> quanResultsList = new ArrayList();
    private long searchSpectrumID;

    public PrecursorIonAreaSearchSpectra(AProgramParameters pp, long quanResultID) {
        super(pp);
        this.quanResultID = quanResultID;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select SearchSpectrumID").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where QuanResultID = ?");
        this.initAndProcessPrepared(this.quanResultID);
    }

    protected final void loadForeignKeyObjects() {
        if (this.quanResultID > -1L && this.quanResult == null) {
            this.requestQuanResult();
        }
        if (this.quanResultID > -1L) {
            this.requestQuanResultsList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private void requestQuanResult() {
        this.quanResult = new QuanResults(this.getPP(), this.quanResultID, this.searchSpectrumID);
    }

    private void requestQuanResultsList() {
        for (Object obj : QuanResults.getObjectIDList(this.getPP(), QuanResults.class)) {
            if (((QuanResults)obj).getQuanResultID() != this.quanResultID) continue;
            this.quanResultsList.add((QuanResults)obj);
        }
    }

    @Override
    protected final void setAllMembers() {
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.searchSpectrumID = this.sql4javaSt.columnLong(1);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            ++this.colIndex;
            try {
                this.searchSpectrumID = this.rs.getLong(2);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    public long getQuanResultID() {
        return this.quanResultID;
    }

    public long getSearchSpectrumID() {
        return this.searchSpectrumID;
    }

    public QuanResults getQuanResult() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.quanResult;
    }

    public ArrayList<QuanResults> getQuanResultsList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.quanResultsList;
    }
}

