/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.PDBaseClassSinglePrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.Peptides;
import de.mpc.PD.ReferenceSpectra;
import java.sql.SQLException;
import java.util.ArrayList;

public class PeptidesReferenceSpectra
extends PDBaseClassSinglePrimaryKey {
    private long peptideID = -1L;
    private long referenceSpectrumID;
    private Peptides peptide = null;
    private ReferenceSpectra referenceSpectra = null;
    private final ArrayList<Peptides> peptidesList = new ArrayList();

    public PeptidesReferenceSpectra(AProgramParameters pp, long peptideID, String version) {
        super(pp);
        strVersion = version;
        this.peptideID = peptideID;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("SELECT referenceSpectrumID*").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("WHERE PeptideID = ?");
        this.initAndProcessPrepared(this.peptideID);
    }

    protected final void loadForeignKeyObjects() {
        if (this.peptideID > -1L && this.peptide == null) {
            this.peptide = this.requestPeptide(this.peptideID);
        }
        if (this.referenceSpectrumID > -1L && this.referenceSpectra == null) {
            this.referenceSpectra = this.requestReferenceSpectra(this.referenceSpectrumID);
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private Peptides requestPeptide(long peptID) {
        return new Peptides(this.getPP(), 2L, peptID, strVersion);
    }

    private ReferenceSpectra requestReferenceSpectra(long referenceSpectrumID) {
        return new ReferenceSpectra(this.getPP(), referenceSpectrumID);
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.referenceSpectrumID = this.sql4javaSt.columnLong(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.referenceSpectrumID = this.rs.getLong(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    public Peptides getPeptide() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.peptide;
    }

    public ReferenceSpectra getReferenceSpectra() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.referenceSpectra;
    }

    public long getPeptideID() {
        return this.peptideID;
    }

    public long getReferenceSpectrumID() {
        return this.referenceSpectrumID;
    }

    public ArrayList<Peptides> getPeptidesList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.peptidesList;
    }
}

