/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.Pair;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.APeptides;
import de.mpc.PD.AminoAcidModifications;
import de.mpc.PD.CustomDataFields;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.Proteins;
import java.sql.SQLException;
import java.util.HashMap;

public class Peptides
extends APeptides {
    private boolean hidden;

    public Peptides(AProgramParameters pp, long processingNodeNumber, long peptideID, String version) {
        super(pp, processingNodeNumber, peptideID);
        strVersion = version;
        this.initFromDB();
    }

    private void initFromDB() {
        if (!strVersion.equals("1.2") && !strVersion.equals("1.1")) {
            this.sb.append("select SpectrumID, TotalIonsCount, MatchedIonsCount, ConfidenceLevel, Hidden, Sequence, Annotation, SearchEngineRank, UniquePeptideSequenceID, MissedCleavages").append(MyConstants.newline);
        } else {
            this.sb.append("select SpectrumID, TotalIonsCount, MatchedIonsCount, ConfidenceLevel, Hidden, Sequence, Annotation").append(MyConstants.newline);
        }
        this.sb.append(this.getFromLine());
        this.sb.append("where ProcessingNodeNumber = ? and PeptideID = ?");
        this.initAndProcessPrepared(this.getProcessingNodeNumber(), this.peptideID);
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.spectrumID = this.sql4javaSt.columnLong(this.colIndex++);
                this.totalIonsCount = (short)this.sql4javaSt.columnInt(this.colIndex++);
                this.matchedIonsCount = (short)this.sql4javaSt.columnInt(this.colIndex++);
                this.confidenceLevel = (short)this.sql4javaSt.columnInt(this.colIndex++);
                this.hidden = this.sql4javaSt.columnInt(this.colIndex++) == 1;
                this.sequence = this.sql4javaSt.columnString(this.colIndex++);
                this.annotation = this.sql4javaSt.columnString(this.colIndex++);
                if (!strVersion.equals("1.2") && !strVersion.equals("1.1")) {
                    this.searchEngineRank = this.sql4javaSt.columnInt(this.colIndex++);
                    this.uniquePeptideSequenceID = this.sql4javaSt.columnLong(this.colIndex++);
                    this.missedCleavages = (short)this.sql4javaSt.columnInt(this.colIndex++);
                }
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.spectrumID = this.rs.getLong(this.colIndex++);
                this.totalIonsCount = this.rs.getShort(this.colIndex++);
                this.matchedIonsCount = this.rs.getShort(this.colIndex++);
                this.confidenceLevel = this.rs.getShort(this.colIndex++);
                this.hidden = this.rs.getInt(this.colIndex++) == 1;
                this.sequence = this.rs.getString(this.colIndex++);
                this.annotation = this.rs.getString(this.colIndex++);
                if (!strVersion.equals("1.2") && !strVersion.equals("1.1")) {
                    this.searchEngineRank = this.rs.getInt(this.colIndex++);
                    this.uniquePeptideSequenceID = this.rs.getLong(this.colIndex++);
                    this.missedCleavages = this.rs.getShort(this.colIndex++);
                }
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    @Override
    public long getFirstID() {
        return this.processingNodeNumber;
    }

    @Override
    public long getSecondID() {
        return this.peptideID;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    protected final HashMap<Pair<Long, Long>, CustomDataFields> getCustomDataFields() {
        StringBuilder strB = new StringBuilder("select cdf.FieldID").append(MyConstants.newline);
        strB.append("from ").append("Peptides as pept, ").append("CustomDataFields as cdf, ").append("CustomDataPeptides as link").append(MyConstants.newline);
        strB.append("where pept.PeptideID = ").append(this.getPeptideID()).append(" and pept.ProcessingNodeNumber = ").append(this.getProcessingNodeNumber()).append(MyConstants.newline);
        strB.append("and link.FieldID = cdf.FieldID").append(MyConstants.newline);
        strB.append("and link.PeptideID = pept.PeptideID");
        this.fillPairedPrimaryKeyGenericMap(strB.toString(), this.customDataMap, CustomDataFields.class, this.getProcessingNodeNumber(), this.getPeptideID());
        this.bFilledCustomDataMap = true;
        return this.customDataMap;
    }

    @Override
    protected final HashMap<Pair<Long, Long>, Proteins> getProteins() {
        StringBuilder strB = new StringBuilder("select prot.ProteinID").append(MyConstants.newline);
        strB.append("from ").append("Peptides as pept, ").append("Proteins as prot, ").append("PeptidesProteins as link").append(MyConstants.newline);
        strB.append("where pept.PeptideID = ").append(this.getPeptideID()).append(" and pept.ProcessingNodeNumber = ").append(this.getProcessingNodeNumber()).append(MyConstants.newline);
        strB.append("and link.ProteinID = prot.ProteinID").append(MyConstants.newline);
        strB.append("and link.ProcessingNodeNumber = pept.ProcessingNodeNumber").append(MyConstants.newline);
        strB.append("and link.PeptideID = pept.PeptideID");
        this.fillPairedPrimaryKeyGenericMap(strB.toString(), this.proteinsMap, Proteins.class, this.getProcessingNodeNumber(), this.getPeptideID());
        this.bFilledProteinsMap = true;
        return this.proteinsMap;
    }

    @Override
    protected final HashMap<Pair<Long, Long>, AminoAcidModifications> getTerminalModifications() {
        StringBuilder strB = new StringBuilder("select tmod.TerminalModificationID").append(MyConstants.newline);
        strB.append("from ").append("Peptides as pept, ").append("AminoAcidModifications as tmod, ").append("PeptidesTerminalModifications as link").append(MyConstants.newline);
        strB.append("where pept.PeptideID = ").append(this.getPeptideID()).append(" and pept.ProcessingNodeNumber = ").append(this.getProcessingNodeNumber()).append(MyConstants.newline);
        strB.append("and link.TerminalModificationID = tmod.TerminalModificationID").append(MyConstants.newline);
        strB.append("and link.ProcessingNodeNumber = pept.ProcessingNodeNumber").append(MyConstants.newline);
        strB.append("and link.PeptideID = pept.PeptideID");
        this.fillPairedPrimaryKeyGenericMap(strB.toString(), this.terminalModificationsMap, AminoAcidModifications.class, this.getProcessingNodeNumber(), this.getPeptideID());
        this.bFilledTerminalModificationsMap = true;
        return this.terminalModificationsMap;
    }
}

