/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD.Params;

import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.CvtBaseLib.SpecObj.SpecifiedOrganization;
import de.mpc.CvtBaseLib.SpecObj.SpecifiedResearcher;
import de.mpc.MzIdentML11Wrapper.CvParamCreator;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.Params.IParameterizable;
import de.mpc.PD.Params.SampleInfos;

public class PDProgramParameters
extends AProgramParameters
implements IParameterizable {
    private String protXMLInputFile = "";
    private String nonRedundantProtXMLInputFile = "";
    private SampleInfos sampleInfo = null;

    public PDProgramParameters(String sqliteFile, String protXMLFile, String mzIdentMLFile, SpecifiedOrganization specOrg, SpecifiedResearcher specRes, SampleInfos sampInfo, boolean bUseJDBC, boolean bResolveTaxID, boolean bPDLExport, boolean bUseShortIDs) {
        super(sqliteFile);
        this.protXMLInputFile = protXMLFile;
        this.setMzIdentMLOutputFullFileName(mzIdentMLFile);
        this.setSpecifiedOrganization(specOrg);
        this.setSpecifiedResearcher(specRes);
        this.setSampleInfo(sampInfo);
        this.setJDBCAccessFlag(bUseJDBC);
        this.setTaxIDResolveFlag(bResolveTaxID);
        this.setExportPDLFlag(bPDLExport);
        this.shouldUseShortIDs(bUseShortIDs);
    }

    public PDProgramParameters(String sqliteFile, boolean bUseJDBC) {
        super(sqliteFile);
        this.setJDBCAccessFlag(bUseJDBC);
    }

    public SampleInfos getSampleInfo() {
        return this.sampleInfo;
    }

    public String getProtXMLInputFile() {
        return this.protXMLInputFile;
    }

    public String getNonRedundantProtXMLInputFile() {
        return this.nonRedundantProtXMLInputFile;
    }

    public final void setSampleInfo(SampleInfos sampInfo) {
        this.sampleInfo = sampInfo;
    }

    public void setProtXMLInputFile(String fileName) {
        this.protXMLInputFile = fileName;
    }

    public void setNonRedundantProtXMLInputFile(String nonRedFileName) {
        this.nonRedundantProtXMLInputFile = nonRedFileName;
    }

    public String toString() {
        StringBuilder strB = new StringBuilder();
        strB.append("bCalcTheoreticalMz:\t").append(this.doMzCalculation()).append(MyConstants.newline);
        strB.append("bCalcPI:\t").append(this.doPICalculation()).append(MyConstants.newline);
        strB.append("bLogDBStructure:\t").append(this.doDBStructureLogging()).append(MyConstants.newline);
        strB.append("makePDLExport:\t").append(this.makePDLExport()).append(MyConstants.newline);
        strB.append("bResolveTaxID:\t").append(this.doTaxIDResolving()).append(MyConstants.newline);
        strB.append("piCalcMethod:\t").append(this.getPICalculationMethod()).append(MyConstants.newline);
        strB.append("mzIdentMLOutputFullFileName:\t").append(this.getMzIdentMLOutputFullFileName()).append(MyConstants.newline);
        strB.append("mzIdentMLOutputFilePath:\t").append(this.getMzIdentMLOutputFilePath()).append(MyConstants.newline);
        strB.append("specOrganization:\t").append(this.getSpecifiedOrganization()).append(MyConstants.newline);
        strB.append("specResearcher:\t").append(this.getSpecifiedResearcher()).append(MyConstants.newline);
        SampleInfos sampInfo = this.getSampleInfo();
        if (sampInfo != null) {
            strB.append("sampleName:\t").append(sampInfo.getSampleName()).append(MyConstants.newline);
            CvParamCreator cpc = sampInfo.getCellTypeCV();
            if (cpc != null) {
                strB.append("cellType:\t").append(cpc.cvParam.getValue()).append(MyConstants.newline);
            }
            if ((cpc = sampInfo.getOrganismCV()) != null) {
                strB.append("organism:\t").append(cpc.cvParam.getValue()).append(MyConstants.newline);
            }
            if ((cpc = sampInfo.getTissueCV()) != null) {
                strB.append("tissue:\t").append(cpc.cvParam.getValue()).append(MyConstants.newline);
            }
        }
        strB.append("dbParams:\t").append(this.getDBParams()).append(MyConstants.newline);
        strB.append("sqliteInputFile:\t").append(this.sqliteInputFile).append(MyConstants.newline);
        strB.append("sqliteAccess:\t").append(this.sqliteAccess).append(MyConstants.newline);
        strB.append("jdbcAccess:\t").append(this.jdbcAccess).append(MyConstants.newline);
        strB.append("bUseJDBC:\t").append(this.isUsingJDBC()).append(MyConstants.newline);
        strB.append("protXMLInputFile:\t").append(this.getProtXMLInputFile()).append(MyConstants.newline);
        strB.append("nonRedundantProtXMLInputFile:\t").append(this.getNonRedundantProtXMLInputFile()).append(MyConstants.newline);
        strB.append("mzIdentMLOutputFile:\t").append(this.getMzIdentMLOutputFullFileName()).append(MyConstants.newline);
        return strB.toString();
    }
}

