/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD.Params;

import de.mpc.CvtBaseLib.AProgParams;
import de.mpc.PD.DB.JDBCAccess;
import de.mpc.PD.DB.SQLiteAccess;
import de.mpc.PD.Params.IParameterizable;
import de.mpc.PD.SchemaInfo;

public abstract class AProgramParameters
extends AProgParams
implements IParameterizable {
    protected String sqliteInputFile = null;
    protected SQLiteAccess sqliteAccess = null;
    protected JDBCAccess jdbcAccess = null;
    private boolean bUseJDBC = true;

    public AProgramParameters(String sqliteFile) {
        this.sqliteInputFile = sqliteFile;
    }

    @Override
    public String getSQLiteInputFile() {
        return this.sqliteInputFile;
    }

    @Override
    public SQLiteAccess getSQLiteAccess() {
        return this.sqliteAccess;
    }

    @Override
    public JDBCAccess getJDBCAccess() {
        return this.jdbcAccess;
    }

    @Override
    public boolean isUsingJDBC() {
        return this.bUseJDBC;
    }

    @Override
    public boolean isUsingSQLite4Java() {
        return !this.bUseJDBC;
    }

    @Override
    public void setSQLiteAccess(SQLiteAccess sqliteAccess) {
        this.bUseJDBC = false;
        this.sqliteAccess = sqliteAccess;
        this.jdbcAccess = null;
    }

    @Override
    public void setJDBCAccess(JDBCAccess jdbcAccess) {
        this.bUseJDBC = true;
        this.jdbcAccess = jdbcAccess;
        this.sqliteAccess = null;
    }

    public void setJDBCAccessFlag(boolean bFlag) {
        this.bUseJDBC = bFlag;
    }

    public void closeDB() {
        if (this.isUsingSQLite4Java()) {
            this.getSQLiteAccess().closeDB();
        } else {
            this.getJDBCAccess().closeDB();
        }
    }

    public String getMSFVersion() {
        SchemaInfo si = new SchemaInfo(this);
        return si.getSoftwareVersion();
    }
}

