/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.Pair;
import de.mpc.PD.ABaseClass;
import de.mpc.PD.PDBaseClassPairedPrimaryKey;
import de.mpc.PD.PDBaseClassSinglePrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.SchemaInfo;
import java.sql.SQLException;
import java.util.HashMap;

public abstract class PDBaseClass
extends ABaseClass {
    private static final String STR_MUST_OVERRIDE_PD = "Must override setAllMembers() of PDBaseClass derivatives";
    private final long VERS_14 = 79L;
    protected boolean bForeignKeyObjectsLoaded = false;
    protected boolean bGUIDObjectsLoaded = false;

    protected PDBaseClass(AProgramParameters pp) {
        super(pp);
    }

    protected final void initAndProcessPreparedPD() {
        this.initAndProcessPrepared(new long[0]);
    }

    @Override
    protected void setAllMembers() {
        this.logger.error(STR_MUST_OVERRIDE_PD);
    }

    protected boolean isNotNull(Object obj) {
        if (obj == null) {
            this.logger.error(String.valueOf(" is null in ") + this.getClass().getSimpleName());
            return false;
        }
        return true;
    }

    protected final <T> void fillSinglePrimaryKeyGenericMap(String sqlStr, HashMap<Long, T> map, Class klasse, long parentID, long ... pnns) {
        block15: {
            String className = klasse.getSimpleName();
            int primKeyIndex = -1;
            if (PDBaseClassSinglePrimaryKey.isSinglePrimaryKeyClass(klasse)) {
                primKeyIndex = this.colSinglePrimaryKeyIndex;
            }
            if (primKeyIndex > -1) {
                if (this.getPP().isUsingSQLite4Java()) {
                    try {
                        if (this.sql4javaSt != null) {
                            this.processPreparedSQLiteStatement(this.sql4javaSt, sqlStr);
                            while (this.sql4javaSt.step()) {
                                this.bFound = true;
                                long id = this.sql4javaSt.columnLong(primKeyIndex);
                                String tmpStr = " for " + this.getClass().getName() + " with ID: " + this.getID();
                                this.logger.debug("Filled {} with ID {} into map", new Object[]{className, id, tmpStr});
                                this.putSinglePrimaryKeyObjectIntoCorrespondingMap(className, id, map, new long[0]);
                            }
                            if (!this.bFound && this.bWarnOnNotFound) {
                                this.showWarning(this.getWarningMessage(), this.sb.toString());
                            }
                            this.sql4javaSt.dispose();
                            break block15;
                        }
                        this.showError(this.getErrorMessage(), this.sb.toString());
                    }
                    catch (SQLiteException sqliteex) {
                        this.handleSQLiteException(sqliteex);
                    }
                } else {
                    try {
                        if (sqlStr.indexOf(63) == -1) {
                            this.jdbcSt = this.initJDBCStatement(sqlStr);
                            if (this.jdbcSt.execute(sqlStr)) {
                                this.rs = this.jdbcSt.getResultSet();
                                this.processSinglePrimaryKeyObjectResultSetJDBC(className, map);
                            }
                            this.jdbcSt.close();
                            break block15;
                        }
                        this.jdbcPrepSt = this.initPreparedJDBCStatement(sqlStr, new long[0]);
                        if (this.jdbcPrepSt != null) {
                            this.processPreparedJDBCStatement(this.jdbcPrepSt, sqlStr);
                            this.rs = this.jdbcPrepSt.executeQuery();
                            this.processSinglePrimaryKeyObjectResultSetJDBC(className, map);
                            this.jdbcPrepSt.close();
                            break block15;
                        }
                        this.showError(this.getErrorMessage(), this.sb.toString());
                    }
                    catch (SQLException sqlex) {
                        this.handleSQLException(sqlex);
                    }
                }
            } else {
                this.logger.error("ERROR: Call of fillSinglePrimKeyGenericMap() not allowed for class {}", (Object)className);
            }
        }
    }

    protected final <T> void fillPairedPrimaryKeyGenericMap(String sqlStr, HashMap<Pair<Long, Long>, T> map, Class klasse, long parentID1, long parentID2) {
        block15: {
            String className = klasse.getSimpleName();
            int primKeyIndexFirst = -1;
            int primKeyIndexSecond = -1;
            if (PDBaseClassPairedPrimaryKey.isPairedPrimaryKeyClass(klasse)) {
                primKeyIndexFirst = this.colPairedPrimaryKeyFirstIndex;
                primKeyIndexSecond = this.colPairedPrimaryKeySecondIndex;
            }
            if (primKeyIndexSecond > -1 && primKeyIndexSecond > -1) {
                if (this.getPP().isUsingSQLite4Java()) {
                    try {
                        if (this.sql4javaSt != null) {
                            this.processPreparedSQLiteStatement(this.sql4javaSt, sqlStr);
                            while (this.sql4javaSt.step()) {
                                this.bFound = true;
                                long idFirst = this.sql4javaSt.columnLong(primKeyIndexFirst);
                                long idSecond = this.sql4javaSt.columnLong(primKeyIndexSecond);
                                String tmpStr = " for " + this.getClass().getName() + " with ID's: " + this.getFirstID() + " and " + this.getSecondID();
                                this.logger.debug("Filled {} with ID's {} and {} into map", new Object[]{className, idFirst, idSecond, tmpStr});
                                this.putPairedPrimaryKeyObjectIntoCorrespondingMap(className, (Pair<Long, Long>)new Pair((Object)idFirst, (Object)idSecond), map);
                            }
                            if (!this.bFound && this.bWarnOnNotFound) {
                                this.showWarning(this.getWarningMessage(), this.sb.toString());
                            }
                            this.sql4javaSt.dispose();
                            break block15;
                        }
                        this.showError(this.getErrorMessage(), this.sb.toString());
                    }
                    catch (SQLiteException sqliteex) {
                        this.handleSQLiteException(sqliteex);
                    }
                } else {
                    try {
                        if (sqlStr.indexOf(63) == -1) {
                            this.jdbcSt = this.initJDBCStatement(sqlStr);
                            if (this.jdbcSt.execute(sqlStr)) {
                                this.rs = this.jdbcSt.getResultSet();
                                this.processPairedPrimaryKeyObjectResultSetJDBC(className, map, parentID1, parentID2);
                            }
                            this.jdbcSt.close();
                            break block15;
                        }
                        this.jdbcPrepSt = this.initPreparedJDBCStatement(sqlStr, new long[0]);
                        if (this.jdbcPrepSt != null) {
                            this.processPreparedJDBCStatement(this.jdbcPrepSt, sqlStr);
                            this.rs = this.jdbcPrepSt.executeQuery();
                            this.processPairedPrimaryKeyObjectResultSetJDBC(className, map, parentID1, parentID2);
                            this.jdbcPrepSt.close();
                            break block15;
                        }
                        this.showError(this.getErrorMessage(), this.sb.toString());
                    }
                    catch (SQLException sqlex) {
                        this.handleSQLException(sqlex);
                    }
                }
            } else {
                this.logger.error("ERROR: Call of fillPairedPrimKeyGenericMap() not allowed for class {}", (Object)className);
            }
        }
    }

    protected final boolean isVersion14() {
        SchemaInfo si = new SchemaInfo(this.getPP());
        return si.getVersion() == 79L;
    }

    protected final int getStartingColIndex() {
        if (this.getPP().isUsingSQLite4Java()) {
            return 0;
        }
        return 1;
    }
}

