/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.FileInfos;
import de.mpc.PD.IMZable;
import de.mpc.PD.PDBaseClassSinglePrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public class MassPeaks
extends PDBaseClassSinglePrimaryKey
implements IMZable {
    private long massPeakID = -1L;
    private short charge;
    private double intensity;
    private double mass;
    private String scanNumbers;
    private long fileID;
    private float percentIsolationInterference;
    private int ionInjectTime;
    private FileInfos fileInfo = null;
    private final ArrayList<FileInfos> fileInfosList = new ArrayList();
    private final HashMap<Long, MassPeaks> relatedMassPeaksMap = new HashMap();
    private boolean bFilledRelatedMassPeaksMap = false;

    public MassPeaks(AProgramParameters pp, long massPeakID) {
        super(pp);
        this.massPeakID = massPeakID;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select Charge, Intensity, Mass, ScanNumbers, FileID, PercentIsolationInterference, IonInjectTime").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where MassPeakID = ?");
        this.initAndProcessPrepared(this.massPeakID);
    }

    private void loadForeignKeyObjects() {
        if (this.fileID > -1L && this.fileInfo == null) {
            this.fileInfo = this.requestFileInfo(this.fileID);
        }
        if (this.fileID > -1L) {
            this.requestFileInfosList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private FileInfos requestFileInfo(long fileInfoID) {
        return new FileInfos(this.getPP(), fileInfoID);
    }

    private void requestFileInfosList() {
        for (Object obj : FileInfos.getObjectIDList(this.getPP(), FileInfos.class)) {
            this.fileInfosList.add(new FileInfos(this.getPP(), (Long)obj));
        }
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.charge = (short)this.sql4javaSt.columnInt(this.colIndex++);
                this.intensity = this.sql4javaSt.columnDouble(this.colIndex++);
                this.mass = this.sql4javaSt.columnDouble(this.colIndex++);
                this.scanNumbers = this.sql4javaSt.columnString(this.colIndex++);
                this.fileID = this.sql4javaSt.columnLong(this.colIndex++);
                this.percentIsolationInterference = (float)this.sql4javaSt.columnDouble(this.colIndex++);
                this.ionInjectTime = this.sql4javaSt.columnInt(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.charge = this.rs.getShort(this.colIndex++);
                this.intensity = this.rs.getDouble(this.colIndex++);
                this.mass = this.rs.getDouble(this.colIndex++);
                this.scanNumbers = this.rs.getString(this.colIndex++);
                this.fileID = this.rs.getLong(this.colIndex++);
                this.percentIsolationInterference = this.rs.getFloat(this.colIndex++);
                this.ionInjectTime = this.rs.getInt(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    @Override
    public long getID() {
        return this.massPeakID;
    }

    public long getMassPeakID() {
        return this.massPeakID;
    }

    public short getCharge() {
        return this.charge;
    }

    public double getIntensity() {
        return this.intensity;
    }

    public double getMass() {
        return this.mass;
    }

    public String getScanNumbers() {
        return this.scanNumbers;
    }

    public long getFileID() {
        return this.fileID;
    }

    public float getPercentIsolationInterference() {
        return this.percentIsolationInterference;
    }

    public int getIonInjectTime() {
        return this.ionInjectTime;
    }

    @Override
    public float getMz() {
        if (this.charge != 0) {
            return (float)(this.mass / (double)this.charge);
        }
        return Float.POSITIVE_INFINITY;
    }

    public ArrayList<FileInfos> getFileInfosList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.fileInfosList;
    }

    public FileInfos getFileInfo() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.fileInfo;
    }

    private HashMap<Long, MassPeaks> getRelatedMassPeaks() {
        StringBuilder strB = new StringBuilder("select mp.MassPeakID").append(MyConstants.newline);
        strB.append("from ").append("MassPeaks as mp, ").append("MassPeakRelations as link, ").append(MyConstants.newline);
        strB.append("where mp.MassPeakID = ").append(this.getMassPeakID()).append(MyConstants.newline);
        strB.append("and link.MassPeakID = mp.MassPeakID").append(MyConstants.newline);
        strB.append("and link.RelatedMassPeakID = mp.MassPeakID");
        this.fillSinglePrimaryKeyGenericMap(strB.toString(), this.relatedMassPeaksMap, MassPeaks.class, this.getMassPeakID(), new long[0]);
        this.bFilledRelatedMassPeaksMap = true;
        return this.relatedMassPeaksMap;
    }

    public MassPeaks getRelatedMassPeak(long ID) {
        if (!this.bFilledRelatedMassPeaksMap) {
            this.getRelatedMassPeaks();
        }
        if (this.relatedMassPeaksMap.containsKey(ID)) {
            return this.relatedMassPeaksMap.get(ID);
        }
        return null;
    }

    public int getNoOfRelatedMassPeaks() {
        if (!this.bFilledRelatedMassPeaksMap) {
            this.getRelatedMassPeaks();
        }
        return this.relatedMassPeaksMap.size();
    }

    public boolean hasRelatedMassPeakLinks() {
        if (!this.bFilledRelatedMassPeaksMap) {
            this.getRelatedMassPeaks();
        }
        return !this.relatedMassPeaksMap.isEmpty();
    }
}

