/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.MassPeaks;
import de.mpc.PD.PDBaseClassPairedPrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import java.util.ArrayList;

public class MassPeakRelations
extends PDBaseClassPairedPrimaryKey {
    private long massPeakID = -1L;
    private long relatedMassPeakID = -1L;
    private MassPeaks massPeak = null;
    private MassPeaks relatedMassPeak = null;
    private final ArrayList<MassPeaks> massPeaksList = new ArrayList();
    private final ArrayList<MassPeaks> relatedMassPeaksList = new ArrayList();

    public MassPeakRelations(AProgramParameters pp, long massPeakID, long relatedMassPeakID) {
        super(pp);
        this.massPeakID = massPeakID;
        this.relatedMassPeakID = relatedMassPeakID;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select *").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where MassPeakID = ? and RelatedMassPeakID = ?");
        this.initAndProcessPrepared(this.massPeakID, this.relatedMassPeakID);
    }

    protected final void loadForeignKeyObjects() {
        if (this.massPeakID > -1L && this.massPeak == null) {
            this.massPeak = this.requestMassPeak(this.massPeakID);
        }
        if (this.relatedMassPeakID > -1L && this.relatedMassPeak == null) {
            this.relatedMassPeak = this.requestMassPeak(this.relatedMassPeakID);
        }
        if (this.massPeakID > -1L) {
            this.requestMassPeaksList();
        }
        if (this.relatedMassPeakID > -1L) {
            this.requestRelatedMassPeaksList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private MassPeaks requestMassPeak(long massPeakID) {
        return new MassPeaks(this.getPP(), massPeakID);
    }

    private void requestMassPeaksList() {
        for (Object obj : MassPeaks.getObjectIDList(this.getPP(), MassPeaks.class)) {
            this.massPeaksList.add(new MassPeaks(this.getPP(), (Long)obj));
        }
    }

    private void requestRelatedMassPeaksList() {
        for (Object obj : MassPeaks.getObjectIDList(this.getPP(), MassPeaks.class)) {
            this.relatedMassPeaksList.add(new MassPeaks(this.getPP(), (Long)obj));
        }
    }

    public long getMassPeakID() {
        return this.massPeakID;
    }

    public long getRelatedMassPeakID() {
        return this.relatedMassPeakID;
    }

    public MassPeaks getMassPeak() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.massPeak;
    }

    public MassPeaks getRelatedMassPeak() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.relatedMassPeak;
    }

    public ArrayList<MassPeaks> getCustomDataFieldsList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.massPeaksList;
    }

    public ArrayList<MassPeaks> getProteinsList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.relatedMassPeaksList;
    }
}

