/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.PDBaseClassPairedPrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.Peptides;
import de.mpc.PD.SpectrumHeaders;
import java.sql.SQLException;
import java.util.ArrayList;

public class IdentifiedPeptides2
extends PDBaseClassPairedPrimaryKey {
    private long peptideID = -1L;
    private long spectrumID = -1L;
    private short confidenceLevel;
    private double scoreValue;
    private final Peptides peptide = null;
    private SpectrumHeaders spectrumHeader = null;
    private final ArrayList<SpectrumHeaders> spectrumList = new ArrayList();

    public IdentifiedPeptides2(AProgramParameters pp, long peptID, long spectID) {
        super(pp);
        this.peptideID = peptID;
        this.spectrumID = spectID;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select ConfidenceLevel, ScoreValue").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where PeptideID = ? and SpectrumID = ?");
        this.initAndProcessPrepared(this.peptideID);
    }

    private void loadForeignKeyObjects() {
        if (this.spectrumID > -1L && this.spectrumHeader == null) {
            this.spectrumHeader = this.requestSpectrumHeader(this.spectrumID);
        }
        if (this.spectrumID > -1L) {
            this.requestSpectrumList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private SpectrumHeaders requestSpectrumHeader(long spectID) {
        return new SpectrumHeaders(this.getPP(), spectID);
    }

    private void requestSpectrumList() {
        for (Object obj : SpectrumHeaders.getObjectIDList(this.getPP(), SpectrumHeaders.class)) {
            this.spectrumList.add(new SpectrumHeaders(this.getPP(), (Long)obj));
        }
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.confidenceLevel = (short)this.sql4javaSt.columnInt(this.colIndex++);
                this.scoreValue = this.sql4javaSt.columnDouble(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.confidenceLevel = this.rs.getShort(this.colIndex++);
                this.scoreValue = this.rs.getDouble(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    public long getPeptideID() {
        return this.peptideID;
    }

    public long getSpectrumID() {
        return this.spectrumID;
    }

    public short getConfidenceLevel() {
        return this.confidenceLevel;
    }

    public double getScoreValue() {
        return this.scoreValue;
    }

    public Peptides getPeptide() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.peptide;
    }

    public SpectrumHeaders getSpectrumHeader() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.spectrumHeader;
    }

    public ArrayList<SpectrumHeaders> getSpectrumList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.spectrumList;
    }
}

