/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.PDBaseClassSinglePrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.SpectrumHeaders;
import java.sql.SQLException;

public class IdentifiedMassPeaks2
extends PDBaseClassSinglePrimaryKey {
    private long spectrumID = -1L;
    private short chargeState;
    private double scoreValue;
    private int peptidesMatched;
    private int decoyPeptidesMatched;
    private SpectrumHeaders spectrumHeader = null;

    public IdentifiedMassPeaks2(AProgramParameters pp, long spectID) {
        super(pp);
        this.spectrumID = spectID;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select ChargeState, ScoreValue, PeptidesMatched, DecoyPeptidesMatched").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where SpectrumID = ?");
        this.initAndProcessPrepared(this.spectrumID);
    }

    private void loadForeignKeyObjects() {
        if (this.spectrumID > -1L && this.spectrumHeader == null) {
            this.spectrumHeader = this.requestSpectrumHeader(this.spectrumID);
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private SpectrumHeaders requestSpectrumHeader(long spectID) {
        return new SpectrumHeaders(this.getPP(), spectID);
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.chargeState = (short)this.sql4javaSt.columnInt(this.colIndex++);
                this.scoreValue = this.sql4javaSt.columnDouble(this.colIndex++);
                this.peptidesMatched = this.sql4javaSt.columnInt(this.colIndex++);
                this.decoyPeptidesMatched = this.sql4javaSt.columnInt(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.chargeState = this.rs.getShort(this.colIndex++);
                this.scoreValue = this.rs.getDouble(this.colIndex++);
                this.peptidesMatched = this.rs.getInt(this.colIndex++);
                this.decoyPeptidesMatched = this.rs.getInt(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    public long getSpectrumID() {
        return this.spectrumID;
    }

    public short getChargeState() {
        return this.chargeState;
    }

    public double getScoreValue() {
        return this.scoreValue;
    }

    public int getPeptidesMatched() {
        return this.peptidesMatched;
    }

    public int getDecoyPeptidesMatched() {
        return this.decoyPeptidesMatched;
    }

    public SpectrumHeaders getSpectrumHeader() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.spectrumHeader;
    }
}

