/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.Helper;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.PDBaseClassSinglePrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import java.math.BigInteger;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FileInfos
extends PDBaseClassSinglePrimaryKey {
    private long fileID = -1L;
    private String fileName;
    private Date fileTime = null;
    private BigInteger fileSize;
    private String physicalFileName;
    private short fileType;

    public FileInfos(AProgramParameters pp, long fileID) {
        super(pp);
        this.fileID = fileID;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select FileName, FileTime, FileSize, PhysicalFileName, FileType").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where FileID = ?");
        this.initAndProcessPrepared(this.fileID);
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.fileName = this.sql4javaSt.columnString(this.colIndex++);
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                this.fileTime = df.parse(this.sql4javaSt.columnString(this.colIndex++));
                this.fileSize = Helper.getBigIntFromStr((String)this.sql4javaSt.columnString(this.colIndex++));
                this.physicalFileName = this.sql4javaSt.columnString(this.colIndex++);
                this.fileType = (short)this.sql4javaSt.columnInt(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
            catch (ParseException pex) {
                pex.printStackTrace(System.err);
            }
        } else {
            try {
                this.fileName = this.rs.getString(this.colIndex++);
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                this.fileTime = df.parse(this.rs.getString(this.colIndex++));
                this.fileSize = Helper.getBigIntFromStr((String)this.rs.getString(this.colIndex++));
                this.physicalFileName = this.rs.getString(this.colIndex++);
                this.fileType = this.rs.getShort(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
            catch (ParseException pex) {
                pex.printStackTrace(System.err);
            }
        }
    }

    public long getFileID() {
        return this.fileID;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Date getFileTime() {
        return this.fileTime;
    }

    public BigInteger getFileSize() {
        return this.fileSize;
    }

    public String getPhysicalFileName() {
        return this.physicalFileName;
    }

    public double getFileType() {
        return this.fileType;
    }
}

