/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.FastaFiles;
import de.mpc.PD.PDBaseClassPairedPrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.ProteinAnnotations;
import java.sql.SQLException;
import java.util.ArrayList;

public class FastaFilesProteinAnnotations
extends PDBaseClassPairedPrimaryKey {
    private long fastaFileID = -1L;
    private long proteinAnnotationID = -1L;
    private FastaFiles fastaFile = null;
    private ProteinAnnotations proteinAnnotation = null;
    private final ArrayList<FastaFiles> fastaFilesList = new ArrayList();
    private final ArrayList<ProteinAnnotations> proteinAnnotationsList = new ArrayList();

    public FastaFilesProteinAnnotations(AProgramParameters pp, long fastaFileID, long proteinAnnotationID) {
        super(pp);
        this.fastaFileID = fastaFileID;
        this.proteinAnnotationID = proteinAnnotationID;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select *").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where FastaFileID = ? and ProteinAnnotationID = ?");
        this.initAndProcessPrepared(this.fastaFileID, this.proteinAnnotationID);
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.fastaFileID = this.sql4javaSt.columnLong(this.colIndex++);
                this.proteinAnnotationID = this.sql4javaSt.columnLong(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.fastaFileID = this.rs.getLong(this.colIndex++);
                this.proteinAnnotationID = this.rs.getLong(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    protected final void loadForeignKeyObjects() {
        if (this.fastaFileID > -1L && this.fastaFile == null) {
            this.requestFastaFile();
        }
        if (this.proteinAnnotationID > -1L && this.proteinAnnotation == null) {
            this.requestProteinAnnotation();
        }
        if (this.fastaFileID > -1L) {
            this.requestFastaFilesList();
        }
        if (this.proteinAnnotationID > -1L) {
            this.requestProteinAnnotationsList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private void requestFastaFile() {
        this.fastaFile = new FastaFiles(this.getPP(), this.fastaFileID);
    }

    private void requestProteinAnnotation() {
        this.proteinAnnotation = new ProteinAnnotations(this.getPP(), this.proteinAnnotationID);
    }

    private void requestFastaFilesList() {
        for (Object obj : FastaFiles.getObjectIDList(this.getPP(), FastaFiles.class)) {
            this.fastaFilesList.add(new FastaFiles(this.getPP(), (Long)obj));
        }
    }

    private void requestProteinAnnotationsList() {
        for (Object obj : ProteinAnnotations.getObjectIDList(this.getPP(), ProteinAnnotations.class)) {
            this.proteinAnnotationsList.add(new ProteinAnnotations(this.getPP(), (Long)obj));
        }
    }

    public long getFastaFileID() {
        return this.fastaFileID;
    }

    public long getProteinAnnotationID() {
        return this.proteinAnnotationID;
    }

    public FastaFiles getFastaFile() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.fastaFile;
    }

    public ProteinAnnotations getProteinAnnotation() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.proteinAnnotation;
    }

    public ArrayList<FastaFiles> getFastaFilesList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.fastaFilesList;
    }

    public ArrayList<ProteinAnnotations> getProteinAnnotationsList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.proteinAnnotationsList;
    }
}

