/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.FileTimes;
import de.mpc.BaseLib.GUID;
import de.mpc.BaseLib.Helper;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.IHashCodable;
import de.mpc.PD.PDBaseClassSinglePrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.ProteinAnnotations;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FastaFiles
extends PDBaseClassSinglePrimaryKey
implements IHashCodable {
    private long fastaFileID = -1L;
    private String fileName;
    private int state;
    private String virtualFileName;
    private BigInteger fileSize;
    private BigInteger fileTime;
    private BigInteger numberOfProteins;
    private BigInteger numberOfAminoAcids;
    private BigInteger fileHashCode;
    private boolean hidden;
    private boolean isSrfImport;
    private boolean isScheduledForDeletion;
    private final HashMap<Long, ProteinAnnotations> proteinAnnotationsMap = new HashMap();
    private boolean bFilledProteinAnnotationsMap = false;

    public FastaFiles(AProgramParameters pp, long fileID) {
        super(pp);
        this.fastaFileID = fileID;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select FileName, State, VirtualFileName, FileSize, FileTime, NumberOfProteins, NumberOfAminoAcids, FileHashCode, Hidden, IsSrfImport, IsScheduledForDeletion").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where FastaFileID = ?");
        this.initAndProcessPrepared(this.fastaFileID);
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.fileName = this.sql4javaSt.columnString(this.colIndex++);
                this.state = this.sql4javaSt.columnInt(this.colIndex++);
                this.virtualFileName = this.sql4javaSt.columnString(this.colIndex++);
                this.fileSize = Helper.getBigIntFromStr((String)this.sql4javaSt.columnString(this.colIndex++));
                this.fileTime = Helper.getBigIntFromStr((String)this.sql4javaSt.columnString(this.colIndex++));
                this.numberOfProteins = Helper.getBigIntFromStr((String)this.sql4javaSt.columnString(this.colIndex++));
                this.numberOfAminoAcids = Helper.getBigIntFromStr((String)this.sql4javaSt.columnString(this.colIndex++));
                this.fileHashCode = Helper.getBigIntFromStr((String)this.sql4javaSt.columnString(this.colIndex++));
                this.hidden = this.sql4javaSt.columnInt(this.colIndex++) == 1;
                this.isSrfImport = this.sql4javaSt.columnInt(this.colIndex++) == 1;
                this.isScheduledForDeletion = this.sql4javaSt.columnInt(this.colIndex++) == 1;
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.fileName = this.rs.getString(this.colIndex++);
                this.state = this.rs.getInt(this.colIndex++);
                this.virtualFileName = this.rs.getString(this.colIndex++);
                this.fileSize = Helper.getBigIntFromStr((String)this.rs.getString(this.colIndex++));
                this.fileTime = Helper.getBigIntFromStr((String)this.rs.getString(this.colIndex++));
                this.numberOfProteins = Helper.getBigIntFromStr((String)this.rs.getString(this.colIndex++));
                this.numberOfAminoAcids = Helper.getBigIntFromStr((String)this.rs.getString(this.colIndex++));
                this.fileHashCode = Helper.getBigIntFromStr((String)this.rs.getString(this.colIndex++));
                this.hidden = this.rs.getInt(this.colIndex++) == 1;
                this.isSrfImport = this.rs.getInt(this.colIndex++) == 1;
                this.isScheduledForDeletion = this.rs.getInt(this.colIndex++) == 1;
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    @Override
    public long getID() {
        return this.fastaFileID;
    }

    public long getFastaFileID() {
        return this.fastaFileID;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getState() {
        return this.state;
    }

    public String getVirtualFileName() {
        return this.virtualFileName;
    }

    public BigInteger getFileSize() {
        return this.fileSize;
    }

    public BigInteger getFileTime() {
        return this.fileTime;
    }

    public BigInteger getNumberOfProteins() {
        return this.numberOfProteins;
    }

    public BigInteger getNumberOfAminoAcids() {
        return this.numberOfAminoAcids;
    }

    public BigInteger getFileHashCode() {
        return this.fileHashCode;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean getIsSrfImport() {
        return this.isSrfImport;
    }

    public boolean isScheduledForDeletion() {
        return this.isScheduledForDeletion;
    }

    @Override
    public BigInteger calculateHashCode(char[] text) {
        BigInteger bigInt = new BigInteger(String.valueOf(Arrays.hashCode(text)));
        return bigInt;
    }

    public GregorianCalendar getFileTimeAsCalendar() {
        return FileTimes.getGregorianCalendar((String)this.fileTime.toString());
    }

    public GUID getGUIDFromFileName() {
        String guidMatch = "";
        if (GUID.containsGUID((String)this.fileName)) {
            Pattern pattern = Pattern.compile("([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})");
            Matcher matcher = pattern.matcher(this.fileName);
            while (matcher.find()) {
                guidMatch = matcher.group(0);
            }
        }
        if (!guidMatch.isEmpty()) {
            return new GUID(guidMatch);
        }
        return null;
    }

    public String getFileExtension() {
        int pos = this.fileName.lastIndexOf(46);
        if (pos > -1) {
            return this.fileName.substring(pos + 1);
        }
        return "";
    }

    public GUID getFileGUID() {
        int pos1 = this.fileName.lastIndexOf(40);
        int pos2 = this.fileName.lastIndexOf(41);
        if (pos1 > -1 && pos2 > -1 && pos2 > pos1) {
            return new GUID(this.fileName.substring(pos1 + 1, pos2));
        }
        return null;
    }

    private HashMap<Long, ProteinAnnotations> getProteinAnnotations() {
        StringBuilder strB = new StringBuilder("select pa.ProteinAnnotationID").append(MyConstants.newline);
        strB.append("from ").append("ProteinAnnotations as pa, ").append("FastaFiles as ff, ").append("FastaFilesProteinAnnotations as link").append(MyConstants.newline);
        strB.append("where ff.FastaFileID = ").append(this.getFastaFileID()).append(MyConstants.newline);
        strB.append("and link.FastaFileID = ff.FastaFileID").append(MyConstants.newline);
        strB.append("and link.ProteinAnnotationID = pa.ProteinAnnotationID");
        this.fillSinglePrimaryKeyGenericMap(strB.toString(), this.proteinAnnotationsMap, ProteinAnnotations.class, this.getFastaFileID(), new long[0]);
        this.bFilledProteinAnnotationsMap = true;
        return this.proteinAnnotationsMap;
    }

    public ProteinAnnotations getProteinAnnotation(long ID) {
        if (!this.bFilledProteinAnnotationsMap) {
            this.getProteinAnnotations();
        }
        if (this.proteinAnnotationsMap.containsKey(ID)) {
            return this.proteinAnnotationsMap.get(ID);
        }
        return null;
    }

    public int getNoOfProteinAnnotations() {
        if (!this.bFilledProteinAnnotationsMap) {
            this.getProteinAnnotations();
        }
        return this.proteinAnnotationsMap.size();
    }

    public boolean hasProteinAnnotationsLinks() {
        if (!this.bFilledProteinAnnotationsMap) {
            this.getProteinAnnotations();
        }
        return !this.proteinAnnotationsMap.isEmpty();
    }
}

