/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.PDBaseClassPairedPrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.ProcessingNodes;
import java.sql.SQLException;
import java.util.ArrayList;

public class FalseDiscoveryRates
extends PDBaseClassPairedPrimaryKey {
    private long processingNodeNumber = -1L;
    private long confidenceLevel = -1L;
    private long trueCount = 0L;
    private long falseCount = 0L;
    private double target = 0.0;
    private ProcessingNodes processingNode = null;
    private final ArrayList<ProcessingNodes> processingNodesList = new ArrayList();

    public FalseDiscoveryRates(AProgramParameters pp, long pNN, long confidenceLevel) {
        super(pp);
        this.processingNodeNumber = pNN;
        this.confidenceLevel = confidenceLevel;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select TrueCount, FalseCount, Target").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.initAndProcessPrepared(new long[0]);
    }

    private void loadForeignKeyObjects() {
        if (this.processingNodeNumber > -1L && this.processingNode == null) {
            this.processingNode = this.requestProcessingNode(this.processingNodeNumber);
        }
        if (this.processingNodeNumber > -1L) {
            this.requestProcessingNodesList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private ProcessingNodes requestProcessingNode(long processingNodeNumber) {
        return new ProcessingNodes(this.getPP(), processingNodeNumber);
    }

    private void requestProcessingNodesList() {
        for (Object obj : ProcessingNodes.getObjectIDList(this.getPP(), ProcessingNodes.class)) {
            this.processingNodesList.add(new ProcessingNodes(this.getPP(), (Long)obj));
        }
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.trueCount = this.sql4javaSt.columnLong(this.colIndex++);
                this.falseCount = this.sql4javaSt.columnLong(this.colIndex++);
                this.target = this.sql4javaSt.columnDouble(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.trueCount = this.rs.getLong(this.colIndex++);
                this.falseCount = this.rs.getLong(this.colIndex++);
                this.target = this.rs.getDouble(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    public long getProcessingNodeNumber() {
        return this.processingNodeNumber;
    }

    public long getConfidenceLevel() {
        return this.confidenceLevel;
    }

    public long getTrueCount() {
        return this.trueCount;
    }

    public long getFalseCount() {
        return this.falseCount;
    }

    public double getTarget() {
        return this.target;
    }

    public ProcessingNodes getProcessingNode() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.processingNode;
    }

    public ArrayList<ProcessingNodes> getProcessingNodesList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.processingNodesList;
    }
}

