/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.FileInfos;
import de.mpc.PD.PDBaseClassSinglePrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import java.sql.SQLException;
import java.util.ArrayList;

public class Events
extends PDBaseClassSinglePrimaryKey {
    private long eventID = -1L;
    private double mass;
    private double massAvg;
    private float area;
    private float intensity;
    private float peakWidth;
    private double RT;
    private float leftRT;
    private float rightRT;
    private float SN;
    private long fileID;
    private FileInfos fileInfo = null;
    private final ArrayList<FileInfos> fileInfosList = new ArrayList();

    public Events(AProgramParameters pp, long eventID) {
        super(pp);
        this.eventID = eventID;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select Mass, MassAvg, Area, Intensity, PeakWidth, RT, LeftRT, RightRT, SN, FileID").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where EventID = ?");
        this.initAndProcessPrepared(this.eventID);
    }

    private void loadForeignKeyObjects() {
        if (this.fileID > -1L && this.fileInfo == null) {
            this.fileInfo = this.requestFileInfo(this.fileID);
        }
        if (this.fileID > -1L) {
            this.requestFileInfosList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private FileInfos requestFileInfo(long fileInfoID) {
        return new FileInfos(this.getPP(), fileInfoID);
    }

    private void requestFileInfosList() {
        for (Object obj : FileInfos.getObjectIDList(this.getPP(), FileInfos.class)) {
            this.fileInfosList.add(new FileInfos(this.getPP(), (Long)obj));
        }
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.mass = this.sql4javaSt.columnDouble(this.colIndex++);
                this.massAvg = this.sql4javaSt.columnDouble(this.colIndex++);
                this.area = (float)this.sql4javaSt.columnDouble(this.colIndex++);
                this.intensity = (float)this.sql4javaSt.columnDouble(this.colIndex++);
                this.peakWidth = (float)this.sql4javaSt.columnDouble(this.colIndex++);
                this.RT = (float)this.sql4javaSt.columnDouble(this.colIndex++);
                this.leftRT = (float)this.sql4javaSt.columnDouble(this.colIndex++);
                this.rightRT = (float)this.sql4javaSt.columnDouble(this.colIndex++);
                this.SN = (float)this.sql4javaSt.columnDouble(this.colIndex++);
                this.fileID = this.sql4javaSt.columnLong(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.mass = this.rs.getDouble(this.colIndex++);
                this.massAvg = this.rs.getDouble(this.colIndex++);
                this.area = this.rs.getFloat(this.colIndex++);
                this.intensity = this.rs.getFloat(this.colIndex++);
                this.peakWidth = this.rs.getFloat(this.colIndex++);
                this.RT = this.rs.getFloat(this.colIndex++);
                this.leftRT = this.rs.getFloat(this.colIndex++);
                this.rightRT = this.rs.getFloat(this.colIndex++);
                this.SN = this.rs.getFloat(this.colIndex++);
                this.fileID = this.rs.getLong(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    public long getEventID() {
        return this.eventID;
    }

    public double getMass() {
        return this.mass;
    }

    public double getMassAvg() {
        return this.massAvg;
    }

    public float getArea() {
        return this.area;
    }

    public float getIntensity() {
        return this.intensity;
    }

    public float getPeakWidth() {
        return this.peakWidth;
    }

    public double getRT() {
        return this.RT;
    }

    public float getLeftRT() {
        return this.leftRT;
    }

    public float getRightRT() {
        return this.rightRT;
    }

    public float getSN() {
        return this.SN;
    }

    public long getFileID() {
        return this.fileID;
    }

    public FileInfos getFileInfos() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.fileInfo;
    }

    public ArrayList<FileInfos> getFileInfosList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.fileInfosList;
    }
}

