/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.Events;
import de.mpc.PD.PDBaseClassSinglePrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import java.sql.SQLException;

public class EventAnnotations
extends PDBaseClassSinglePrimaryKey {
    private long eventID = -1L;
    private short charge;
    private long isotopePatternID;
    private long quanResultID;
    private long quanChannelID;
    private Events event = null;

    public EventAnnotations(AProgramParameters pp, long eventID) {
        super(pp);
        this.eventID = eventID;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select Charge, IsotopePatternID, QuanResultID, QuanChannelID").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where EventID = ?");
        this.initAndProcessPrepared(this.eventID);
    }

    private void loadForeignKeyObjects() {
        if (this.eventID > -1L && this.event == null) {
            this.event = this.requestEvent(this.eventID);
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private Events requestEvent(long evtID) {
        return new Events(this.getPP(), evtID);
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.charge = (short)this.sql4javaSt.columnInt(this.colIndex++);
                this.isotopePatternID = this.sql4javaSt.columnLong(this.colIndex++);
                this.quanResultID = this.sql4javaSt.columnLong(this.colIndex++);
                this.quanChannelID = this.sql4javaSt.columnLong(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.charge = this.rs.getShort(this.colIndex++);
                this.isotopePatternID = this.rs.getLong(this.colIndex++);
                this.quanResultID = this.rs.getLong(this.colIndex++);
                this.quanChannelID = this.rs.getLong(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    public long getEventID() {
        return this.eventID;
    }

    public short getCharge() {
        return this.charge;
    }

    public long getIsotopePatternID() {
        return this.isotopePatternID;
    }

    public long getQuanResultID() {
        return this.quanResultID;
    }

    public long getQuanChannelID() {
        return this.quanChannelID;
    }

    public Events getEvent() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.event;
    }
}

