/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.Enzymes;
import de.mpc.PD.PDBaseClassPairedPrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import java.util.ArrayList;

public class EnzymesCleavageSpecificities
extends PDBaseClassPairedPrimaryKey {
    private long enzymeID = -1L;
    private long specificity = -1L;
    private Enzymes enzyme = null;
    private final ArrayList<Enzymes> enzymesList = new ArrayList();

    public EnzymesCleavageSpecificities(AProgramParameters pp, long enzymeID, long specificity) {
        super(pp);
        this.enzymeID = enzymeID;
        this.specificity = specificity;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select *").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where EnzymeID = ? and Specificity = ?");
        this.initAndProcessPrepared(this.enzymeID, this.specificity);
    }

    private void loadForeignKeyObjects() {
        if (this.enzymeID > -1L && this.enzyme == null) {
            this.enzyme = this.requestEnzyme(this.enzymeID);
        }
        if (this.enzymeID > -1L) {
            this.requestEnzymesList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private Enzymes requestEnzyme(long enzID) {
        return new Enzymes(this.getPP(), enzID);
    }

    private void requestEnzymesList() {
        for (Object obj : Enzymes.getObjectIDList(this.getPP(), Enzymes.class)) {
            this.enzymesList.add(new Enzymes(this.getPP(), (Long)obj));
        }
    }

    public long getEnzymeID() {
        return this.enzymeID;
    }

    public long getSpecificity() {
        return this.specificity;
    }

    public ArrayList<Enzymes> getEnzymesList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.enzymesList;
    }

    public Enzymes getEnzyme() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.enzyme;
    }
}

