/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.PDBaseClassSinglePrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import java.sql.SQLException;

public class Enzymes
extends PDBaseClassSinglePrimaryKey {
    private long enzymeID = -1L;
    private String name = null;
    private String abbreviation = null;
    private String separator = null;
    private String nonSeparator = null;
    private int offset;

    public Enzymes(AProgramParameters pp, long enzymeID) {
        super(pp);
        this.enzymeID = enzymeID;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select Name, Abbreviation, Separator, NonSeparator").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where EnzymeID = ?");
        this.initAndProcessPrepared(this.enzymeID);
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.name = this.sql4javaSt.columnString(this.colIndex++);
                this.abbreviation = this.sql4javaSt.columnString(this.colIndex++);
                this.separator = this.sql4javaSt.columnString(this.colIndex++);
                this.nonSeparator = this.sql4javaSt.columnString(this.colIndex++);
                this.offset = this.sql4javaSt.columnInt(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.name = this.rs.getString(this.colIndex++);
                this.abbreviation = this.rs.getString(this.colIndex++);
                this.separator = this.rs.getString(this.colIndex++);
                this.nonSeparator = this.rs.getString(this.colIndex++);
                this.offset = this.rs.getInt(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    public long getEnzymeID() {
        return this.enzymeID;
    }

    public String getName() {
        return this.name;
    }

    public String getAbbrevaition() {
        return this.abbreviation;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getNonSeparator() {
        return this.nonSeparator;
    }

    public int getOffset() {
        return this.offset;
    }
}

