/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD.DB;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import de.mpc.PD.DB.ADBAccessObject;
import de.mpc.PD.DB.ISQLite4JavaAccessable;
import java.io.File;

public class SQLiteAccess
extends ADBAccessObject
implements ISQLite4JavaAccessable {
    public SQLiteConnection dbConn = null;

    @Override
    public void connectToExistingDB(String fileName) {
        if (this.dbConn == null) {
            this.dbConn = new SQLiteConnection(new File(fileName));
            if (this.dbConn != null) {
                try {
                    this.dbConn.openV2(1);
                }
                catch (SQLiteException sex) {
                    this.logger.error("Cannot open the SQLite DB: {} via SQLite4Java", (Object)fileName);
                    this.logger.error("Please download first sqlite4java from http://code.google.com/p/sqlite4java/ and copy the operating system specific files (DLL's resp. *.so or *.jnilib files) into your system directories.");
                    this.handleSQLite4JavaError(sex);
                    System.exit(-1);
                }
            } else {
                this.logger.error("Cannot connect to the SQLite DB: {} via SQLite4Java", (Object)fileName);
                System.exit(-1);
            }
            this.logger.info("Connected and opened the existing DB {} via SQLite4Java", (Object)fileName);
        } else {
            this.logger.debug("Already connected to DB via SQLite4Java.");
        }
    }

    @Override
    public void closeDB() {
        if (this.dbConn != null) {
            this.dbConn.dispose();
            this.logger.info("Connection to DB via SQLite4Java closed");
        } else {
            this.logger.info("DB was already closed via SQLite4Java");
        }
    }

    @Override
    public void handleSQLite4JavaError(SQLiteException sex) {
        this.logSQLCodeAndMessage((Exception)((Object)sex));
        if (this.dbConn == null) {
            this.logger.error("SQLite4Java-Error: No connection to the database");
        }
    }

    protected final void createDBTable(String dbName, String tableName) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        sb.append(tableName);
        sb.append(" (blob BLOB)");
        try {
            SQLiteConnection sQLiteConnection = this.dbConn.exec(sb.toString());
        }
        catch (SQLiteException sex) {
            this.handleSQLite4JavaError(sex);
            sex.printStackTrace(System.err);
        }
    }

    protected final void dropDBTable(String dbName, String tableName) {
        StringBuilder sb = new StringBuilder();
        sb.append("DROP TABLE ");
        sb.append(tableName);
        try {
            SQLiteConnection sQLiteConnection = this.dbConn.exec(sb.toString());
        }
        catch (SQLiteException sex) {
            this.handleSQLite4JavaError(sex);
            sex.printStackTrace(System.err);
        }
    }

    protected final void dropDBTableIfExists(String dbName, String tableName) {
        StringBuilder sb = new StringBuilder();
        sb.append("DROP TABLE IF EXISTS ");
        sb.append(tableName);
        try {
            SQLiteConnection sQLiteConnection = this.dbConn.exec(sb.toString());
        }
        catch (SQLiteException sex) {
            this.handleSQLite4JavaError(sex);
            sex.printStackTrace(System.err);
        }
    }
}

