/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD.DB;

import de.mpc.PD.DB.ADBAccessObject;
import de.mpc.PD.DB.IJDBCAccessable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.sqlite.SQLiteConfig;

public class JDBCAccess
extends ADBAccessObject
implements IJDBCAccessable {
    public Connection dbConn = null;

    @Override
    public void connectToExistingDB(String fileName) {
        if (this.dbConn == null) {
            try {
                Class.forName("org.sqlite.JDBC");
                SQLiteConfig config = new SQLiteConfig();
                config.setReadOnly(true);
                this.dbConn = DriverManager.getConnection("jdbc:sqlite:" + fileName, config.toProperties());
                if (this.dbConn == null) {
                    this.logger.error("Cannot connect to the SQLite DB via JDBC: {}", (Object)fileName);
                    System.exit(-1);
                }
            }
            catch (SQLException sex) {
                this.logger.error("Cannot open the SQLite DB: {} via JDBC", (Object)fileName);
                this.handleJDBCError(sex);
                System.exit(-1);
            }
            catch (ClassNotFoundException cnfex) {
                this.logger.error("Class 'org.sqlite.JDBC' not found: {} for JDBC", (Object)fileName);
                cnfex.printStackTrace(System.err);
                System.exit(-1);
            }
            this.logger.info("Connected and opened the existing DB {} via JDBC", (Object)fileName);
        } else {
            this.logger.debug("Already connected to DB via JDBC.");
        }
    }

    @Override
    public void closeDB() {
        if (this.dbConn != null) {
            try {
                this.dbConn.close();
                this.logger.info("Connection to DB via JDBC closed");
            }
            catch (SQLException sex) {
                sex.printStackTrace(System.err);
            }
        } else {
            this.logger.info("DB was already closed via JDBC");
        }
    }

    @Override
    public void handleJDBCError(SQLException sex) {
        this.logSQLCodeAndMessage(sex);
        if (this.dbConn == null) {
            this.logger.error("JDBC-Error(JDBC): No connection to the database");
        }
    }
}

