/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.Variant;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.CustomDataFields;
import de.mpc.PD.PDBaseClassPairedPrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.SpectrumHeaders;
import java.sql.SQLException;
import java.util.ArrayList;

public class CustomDataSpectra
extends PDBaseClassPairedPrimaryKey {
    private long fieldID = -1L;
    private long spectrumID = -1L;
    private Variant fieldValue = null;
    private CustomDataFields customDataField = null;
    private SpectrumHeaders spectrum = null;
    private final ArrayList<CustomDataFields> customDataFieldsList = new ArrayList();
    private final ArrayList<SpectrumHeaders> spectrumHeadersList = new ArrayList();

    public CustomDataSpectra(AProgramParameters pp, long fieldID, long spectrumID, Variant varValue) {
        super(pp);
        this.setInitialValues(fieldID, spectrumID, varValue);
    }

    public CustomDataSpectra(AProgramParameters pp, long fieldID, long spectrumID) {
        super(pp);
        this.setInitialValues(fieldID, spectrumID, new Variant(""));
    }

    private void setInitialValues(long fieldID, long spectrumID, Variant varValue) {
        this.fieldID = fieldID;
        this.spectrumID = spectrumID;
        this.fieldValue = varValue;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select FieldValue").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where FieldID = ? and SpectrumID = ?");
        this.initAndProcessPrepared(this.fieldID, this.spectrumID);
    }

    private void loadForeignKeyObjects() {
        if (this.fieldID > -1L && this.customDataField == null) {
            this.requestCustomDataField();
        }
        if (this.spectrumID > -1L && this.spectrum == null) {
            this.requestSpectrum();
        }
        if (this.fieldID > -1L) {
            this.requestCustomDataFieldsList();
        }
        if (this.spectrumID > -1L) {
            this.requestSpectrumHeadersList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private void requestCustomDataField() {
        this.customDataField = new CustomDataFields(this.getPP(), this.fieldID);
    }

    private void requestSpectrum() {
        this.spectrum = new SpectrumHeaders(this.getPP(), this.spectrumID);
    }

    private void requestCustomDataFieldsList() {
        for (Object obj : CustomDataFields.getObjectIDList(this.getPP(), CustomDataFields.class)) {
            this.customDataFieldsList.add(new CustomDataFields(this.getPP(), (Long)obj));
        }
    }

    private void requestSpectrumHeadersList() {
        for (Object obj : SpectrumHeaders.getObjectIDList(this.getPP(), SpectrumHeaders.class)) {
            this.spectrumHeadersList.add(new SpectrumHeaders(this.getPP(), (Long)obj));
        }
    }

    @Override
    protected final void setAllMembers() {
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.fieldValue = new Variant(this.sql4javaSt.columnString(0));
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            ++this.colIndex;
            try {
                this.fieldValue = new Variant(this.rs.getString(1));
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    public long getFieldID() {
        return this.fieldID;
    }

    public long getSpectrumID() {
        return this.spectrumID;
    }

    public long getFieldAsLongValue() {
        return this.fieldValue.getLongValue();
    }

    public double getFieldAsDoubleValue() {
        return this.fieldValue.getDoubleValue();
    }

    public CustomDataFields getCustomDataField() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.customDataField;
    }

    public SpectrumHeaders getSpectrum() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.spectrum;
    }

    public ArrayList<CustomDataFields> getCustomDataFieldsList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.customDataFieldsList;
    }

    public ArrayList<SpectrumHeaders> getSpectrumHeadersList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.spectrumHeadersList;
    }
}

