/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.Variant;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.CustomDataFields;
import de.mpc.PD.IPNNListable;
import de.mpc.PD.PDBaseClassPairedPrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.ProcessingNodes;
import de.mpc.PD.SMsFromPNN;
import java.sql.SQLException;
import java.util.ArrayList;

public class CustomDataProcessingNodes
extends PDBaseClassPairedPrimaryKey
implements IPNNListable {
    private long fieldID = -1L;
    private long processingNodeNumber = -1L;
    private Variant fieldValue = null;
    private CustomDataFields customDataField = null;
    private final ArrayList<CustomDataFields> customDataFieldsList = new ArrayList();
    private final ArrayList<ProcessingNodes> processingNodesList = new ArrayList();
    private final String searchMachine;

    public CustomDataProcessingNodes(AProgramParameters pp, long fieldID, long processingNodeNo) {
        super(pp);
        this.fieldID = fieldID;
        this.processingNodeNumber = processingNodeNo;
        this.fieldValue = new Variant("");
        this.initFromDB();
        this.searchMachine = SMsFromPNN.retrieveSearchMachineForProcessingNodeNumber(pp, this.processingNodeNumber);
    }

    private void initFromDB() {
        this.sb.append("select FieldValue").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where FieldID = ? and ProcessingNodeNumber = ?");
        this.initAndProcessPrepared(this.fieldID, this.getProcessingNodeNumber());
    }

    private void loadForeignKeyObjects() {
        if (this.fieldID > -1L && this.customDataField == null) {
            this.requestCustomDataField();
        }
        if (this.fieldID > -1L) {
            this.requestCustomDataFieldsList();
        }
        if (this.processingNodeNumber > -1L) {
            this.requestProcessingNodesList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private void requestCustomDataField() {
        this.customDataField = new CustomDataFields(this.getPP(), this.fieldID);
    }

    private void requestCustomDataFieldsList() {
        for (Object obj : CustomDataFields.getObjectIDList(this.getPP(), CustomDataFields.class)) {
            this.customDataFieldsList.add(new CustomDataFields(this.getPP(), (Long)obj));
        }
    }

    private void requestProcessingNodesList() {
        for (Object obj : ProcessingNodes.getObjectIDList(this.getPP(), ProcessingNodes.class)) {
            this.processingNodesList.add(new ProcessingNodes(this.getPP(), (Long)obj));
        }
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.fieldValue = new Variant(this.sql4javaSt.columnString(this.colIndex));
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.fieldValue = new Variant(this.rs.getString(this.colIndex));
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    public long getFieldID() {
        return this.fieldID;
    }

    public long getFieldValue() {
        return this.fieldValue.getLongValue();
    }

    public double getFieldAsDoubleValue() {
        return this.fieldValue.getDoubleValue();
    }

    public CustomDataFields getCustomDataField() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.customDataField;
    }

    public ArrayList<CustomDataFields> getCustomDataFieldsList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.customDataFieldsList;
    }

    @Override
    public long getProcessingNodeNumber() {
        return this.processingNodeNumber;
    }

    @Override
    public ArrayList<ProcessingNodes> getProcessingNodesList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.processingNodesList;
    }

    @Override
    public String getSearchMachine() {
        return this.searchMachine;
    }
}

