/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.PDBaseClassSinglePrimaryKey;
import de.mpc.PD.PD_GUID;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.ProcessingNodes;
import java.sql.SQLException;
import java.util.ArrayList;

public class CustomDataFields
extends PDBaseClassSinglePrimaryKey {
    private long fieldID = -1L;
    private PD_GUID guid = null;
    private String displayName;
    private int sourceNodeNumber;
    private int targetNodeNumber;
    private int dataType;
    private int dataTarget;
    private double version;
    private int accessMode;
    private int visibility;
    private int groupVisibility;
    private String format;
    private int plotType;
    private String dataPurpose;
    private ProcessingNodes sourceProcessingNode = null;
    private ProcessingNodes targetProcessingNode = null;
    private final ArrayList<ProcessingNodes> sourceProcessingNodesList = new ArrayList();
    private final ArrayList<ProcessingNodes> targetProcessingNodesList = new ArrayList();

    public CustomDataFields(AProgramParameters pp, long fID) {
        super(pp);
        this.fieldID = fID;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select Guid, DisplayName, SourceNodeNumber, TargetNodenumber, DataType, DataTarget, Version, AccessMode, Visibility, GroupVisibility, Format, PlotType, DataPurpose").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where FieldID = ?");
        this.initAndProcessPrepared(this.fieldID);
    }

    private void loadForeignKeyObjects() {
        if ((long)this.sourceNodeNumber > -1L && this.sourceProcessingNode == null) {
            this.sourceProcessingNode = this.requestProcessingNode(this.sourceNodeNumber);
        }
        if ((long)this.targetNodeNumber > -1L && this.targetProcessingNode == null) {
            this.targetProcessingNode = this.requestProcessingNode(this.targetNodeNumber);
        }
        if ((long)this.sourceNodeNumber > -1L) {
            this.requestSourceProcessingNodesList();
        }
        if ((long)this.targetNodeNumber > -1L) {
            this.requestTargetProcessingNodesList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private ProcessingNodes requestProcessingNode(long nodeNumber) {
        return new ProcessingNodes(this.getPP(), nodeNumber);
    }

    private void requestSourceProcessingNodesList() {
        for (Object obj : ProcessingNodes.getObjectIDList(this.getPP(), ProcessingNodes.class)) {
            this.sourceProcessingNodesList.add(new ProcessingNodes(this.getPP(), (Long)obj));
        }
    }

    private void requestTargetProcessingNodesList() {
        for (Object obj : ProcessingNodes.getObjectIDList(this.getPP(), ProcessingNodes.class)) {
            this.targetProcessingNodesList.add(new ProcessingNodes(this.getPP(), (Long)obj));
        }
    }

    private void loadGUIDObjects() {
        if (this.guid != null) assert (this.isNotNull((Object)this.guid));
        this.bGUIDObjectsLoaded = true;
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.guid = new PD_GUID(this.sql4javaSt.columnString(this.colIndex++));
                this.displayName = this.sql4javaSt.columnString(this.colIndex++);
                this.sourceNodeNumber = this.sql4javaSt.columnInt(this.colIndex++);
                this.targetNodeNumber = this.sql4javaSt.columnInt(this.colIndex++);
                this.dataType = this.sql4javaSt.columnInt(this.colIndex++);
                this.dataTarget = this.sql4javaSt.columnInt(this.colIndex++);
                this.version = this.sql4javaSt.columnDouble(this.colIndex++);
                this.accessMode = this.sql4javaSt.columnInt(this.colIndex++);
                this.visibility = this.sql4javaSt.columnInt(this.colIndex++);
                this.groupVisibility = this.sql4javaSt.columnInt(this.colIndex++);
                this.format = this.sql4javaSt.columnString(this.colIndex++);
                this.plotType = this.sql4javaSt.columnInt(this.colIndex++);
                this.dataPurpose = this.sql4javaSt.columnString(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.guid = new PD_GUID(this.rs.getString(this.colIndex++));
                this.displayName = this.rs.getString(this.colIndex++);
                this.sourceNodeNumber = this.rs.getInt(this.colIndex++);
                this.targetNodeNumber = this.rs.getInt(this.colIndex++);
                this.dataType = this.rs.getInt(this.colIndex++);
                this.dataTarget = this.rs.getInt(this.colIndex++);
                this.version = this.rs.getDouble(this.colIndex++);
                this.accessMode = this.rs.getInt(this.colIndex++);
                this.visibility = this.rs.getInt(this.colIndex++);
                this.groupVisibility = this.rs.getInt(this.colIndex++);
                this.format = this.rs.getString(this.colIndex++);
                this.plotType = this.rs.getInt(this.colIndex++);
                this.dataPurpose = this.rs.getString(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    public long getFieldID() {
        return this.fieldID;
    }

    public PD_GUID getGuid() {
        return this.guid;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getSourceNodeNumber() {
        return this.sourceNodeNumber;
    }

    public int getTargetNodeNumber() {
        return this.targetNodeNumber;
    }

    public int getDataType() {
        return this.dataType;
    }

    public int getDataTarget() {
        return this.dataTarget;
    }

    public double getVersion() {
        return this.version;
    }

    public int getAccessMode() {
        return this.accessMode;
    }

    public int getVisibility() {
        return this.visibility;
    }

    public int getGroupVisibility() {
        return this.groupVisibility;
    }

    public String getFormat() {
        return this.format;
    }

    public int getPlotType() {
        return this.plotType;
    }

    public String getDataPurpose() {
        return this.dataPurpose;
    }

    public boolean isCountData() {
        return this.dataPurpose.endsWith("Count");
    }

    public boolean isAscending() {
        return this.dataPurpose.endsWith("Ascending");
    }

    public boolean isDescending() {
        return this.dataPurpose.endsWith("Descending");
    }

    public ProcessingNodes getSourceProcessingNode() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.sourceProcessingNode;
    }

    public ProcessingNodes getTargetProcessingNode() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.targetProcessingNode;
    }

    public ArrayList<ProcessingNodes> getSourceProcessingNodesList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.sourceProcessingNodesList;
    }

    public ArrayList<ProcessingNodes> getAminoAcidsList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.targetProcessingNodesList;
    }
}

