/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.Helper;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.FileInfos;
import de.mpc.PD.IUnzippable;
import de.mpc.PD.PDBaseClassPairedPrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class Chromatograms
extends PDBaseClassPairedPrimaryKey
implements IUnzippable {
    private long fileID = -1L;
    private TraceType traceType = TraceType.UNKNOWN;
    private Blob chromatogram = null;
    private FileInfos fileInfo = null;
    private final ArrayList<FileInfos> fileInfosList = new ArrayList();

    public Chromatograms(AProgramParameters pp, long fieldID, TraceType traceType) {
        super(pp);
        this.fileID = fieldID;
        this.traceType = traceType;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select Chromatogram").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where FileID = ? and TraceType = ?");
        this.initAndProcessPrepared(this.fileID, this.traceType.getTraceTypeCode());
    }

    private void loadForeignKeyObjects() {
        if (this.fileID > -1L && this.fileInfo == null) {
            this.fileInfo = this.requestFileInfo(this.fileID);
        }
        if (this.fileID > -1L) {
            this.requestFileInfosList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private FileInfos requestFileInfo(long fileID) {
        return new FileInfos(this.getPP(), fileID);
    }

    private void requestFileInfosList() {
        for (Object obj : FileInfos.getObjectIDList(this.getPP(), FileInfos.class)) {
            this.fileInfosList.add(new FileInfos(this.getPP(), (Long)obj));
        }
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.chromatogram = (Blob)this.sql4javaSt.columnValue(this.colIndex);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        }
    }

    public long getFileID() {
        return this.fileID;
    }

    public TraceType getTraceType() {
        return this.traceType;
    }

    public Blob getChromatogram() {
        return this.chromatogram;
    }

    public String getUnzippedSpectrumXml() {
        return Helper.getUnzippedSpectrumXml((Blob)this.chromatogram);
    }

    public FileInfos getFileInfo() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.fileInfo;
    }

    public ArrayList<FileInfos> getFileInfosList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.fileInfosList;
    }

    @Override
    public String unzipBinaryData(Blob blobData) {
        byte[] output = new byte[]{};
        int dataLen = 0;
        try {
            dataLen = (int)blobData.length();
            Inflater inflater = new Inflater();
            inflater.setInput(blobData.getBytes(1L, dataLen));
            ByteArrayOutputStream outStream = new ByteArrayOutputStream(dataLen);
            byte[] buffer = new byte[4096];
            while (!inflater.finished()) {
                int count = inflater.inflate(buffer);
                outStream.write(buffer, 0, count);
            }
            outStream.close();
            output = outStream.toByteArray();
        }
        catch (IOException | SQLException | DataFormatException sex) {
            sex.printStackTrace(System.err);
        }
        this.logger.trace("Original length: " + dataLen);
        this.logger.trace("Extracted length: " + output.length);
        return new String(output);
    }

    public static enum TraceType {
        UNKNOWN(0L),
        MassRange(1L),
        TIC(2L),
        BasePeak(3L),
        FragmentTrace(4L);

        private final long traceType;

        private TraceType(long traceType) {
            this.traceType = traceType;
        }

        public long getTraceTypeCode() {
            return this.traceType;
        }

        public static TraceType fromStringValue(String valStr) {
            switch (Integer.parseInt(valStr)) {
                case 1: {
                    return MassRange;
                }
                case 2: {
                    return TIC;
                }
                case 3: {
                    return BasePeak;
                }
                case 4: {
                    return FragmentTrace;
                }
            }
            return UNKNOWN;
        }
    }
}

