/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.Annotations;
import de.mpc.PD.PDBaseClass;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.Proteins;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class AnnotationsProtein
extends PDBaseClass {
    private long proteinID = -1L;
    private long annotationID = -1L;
    private long evidence = -1L;
    private long positionBegin = -1L;
    private final String proteinAccession;
    private int positionEnd;
    private Proteins protein = null;
    private Annotations annotation = null;
    private final ArrayList<Proteins> proteinsList = new ArrayList();
    private final ArrayList<Annotations> annotationsList = new ArrayList();

    public AnnotationsProtein(AProgramParameters pp, long proteinID, long annotationID, long evidence, long positionBegin, String proteinAccession) {
        super(pp);
        this.proteinID = proteinID;
        this.annotationID = annotationID;
        this.evidence = evidence;
        this.positionBegin = positionBegin;
        this.proteinAccession = proteinAccession;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select PositionEnd").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where ProteinAccession = ? and ProteinID = ? and AnnotationID = ? and Evidence = ? and PositionBegin = ?");
        this.initAndProcessPrepared(this.proteinAccession, this.proteinID, this.annotationID, this.evidence, this.positionBegin);
    }

    private void loadForeignKeyObjects() {
        if (this.proteinID > -1L && this.protein == null) {
            this.protein = this.requestProtein(this.proteinID);
        }
        if (this.annotationID > -1L && this.annotation == null) {
            this.annotation = this.requestAnnotation(this.annotationID);
        }
        if (this.proteinID > -1L) {
            this.requestProteinsList();
        }
        if (this.annotationID > -1L) {
            this.requestAnnotationsList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private Proteins requestProtein(long protID) {
        return new Proteins(this.getPP(), protID, strVersion);
    }

    private Annotations requestAnnotation(long annotID) {
        return new Annotations(this.getPP(), annotID);
    }

    private void requestProteinsList() {
        for (Object obj : Proteins.getObjectIDList(this.getPP(), Proteins.class)) {
            if (((Proteins)obj).getProteinID() != this.proteinID) continue;
            this.proteinsList.add((Proteins)obj);
        }
    }

    private void requestAnnotationsList() {
        for (Object obj : Annotations.getObjectIDList(this.getPP(), Annotations.class)) {
            this.annotationsList.add(new Annotations(this.getPP(), (Long)obj));
        }
    }

    @Override
    protected final void setAllMembers() {
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.positionEnd = this.sql4javaSt.columnInt(4);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.positionEnd = this.rs.getInt(5);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    public long getProteinID() {
        return this.proteinID;
    }

    public long getAnnotationID() {
        return this.annotationID;
    }

    public long getEvidence() {
        return this.evidence;
    }

    public long getPositionBegin() {
        return this.positionBegin;
    }

    public String getProteinAccession() {
        return this.proteinAccession;
    }

    public int getPositionEnd() {
        return this.positionEnd;
    }

    public String getAnnotatedSequence(long proteinID) {
        StringBuilder strB = new StringBuilder();
        strB.append("SELECT PROT.Sequence").append(MyConstants.newline);
        strB.append("FROM Proteins AS PROT, AnnotationsProtein AS AP").append(MyConstants.newline);
        strB.append("WHERE PROT.ProteinID = AP.ProteinID").append(proteinID);
        strB.append("AND PROT.ProteinID = ").append(proteinID);
        String sqlStr = strB.toString();
        String protSequence = "";
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                SQLiteStatement sqlSt = this.getPP().getSQLiteAccess().dbConn.prepare(sqlStr);
                try {
                    while (sqlSt.step()) {
                        protSequence = sqlSt.columnString(0);
                    }
                }
                finally {
                    sqlSt.dispose();
                }
            }
            catch (SQLiteException sqliteex) {
                this.getPP().getSQLiteAccess().handleSQLite4JavaError(sqliteex);
                sqliteex.printStackTrace(System.err);
            }
        } else if (this.getPP().isUsingJDBC()) {
            try {
                Statement st = this.getPP().getJDBCAccess().dbConn.createStatement();
                this.rs = st.executeQuery(sqlStr);
                try {
                    while (this.rs.next()) {
                        protSequence = this.rs.getString(1);
                    }
                }
                finally {
                    st.close();
                }
            }
            catch (SQLException sex) {
                this.getPP().getJDBCAccess().handleJDBCError(sex);
                sex.printStackTrace(System.err);
            }
        }
        if (!protSequence.isEmpty()) {
            return protSequence.substring((int)this.positionBegin, this.positionEnd);
        }
        return "";
    }

    public Proteins getProtein() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.protein;
    }

    public Annotations getAnnotation() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.annotation;
    }

    public ArrayList<Proteins> getProteinsList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.proteinsList;
    }

    public ArrayList<Annotations> getAnnotationsList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.annotationsList;
    }
}

