/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.AnnotationGroups;
import de.mpc.PD.Annotations;
import de.mpc.PD.PDBaseClassPairedPrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import java.util.ArrayList;

public class AnnotationsAnnotationGroups
extends PDBaseClassPairedPrimaryKey {
    private long annotationID = -1L;
    private long annotationGroupID = -1L;
    private Annotations annotation = null;
    private final ArrayList<Annotations> annotationsList = new ArrayList();
    private final ArrayList<AnnotationGroups> annotationGroupsList = new ArrayList();

    public AnnotationsAnnotationGroups(AProgramParameters pp, long annotationID, long annotationGroupID) {
        super(pp);
        this.annotationID = annotationID;
        this.annotationGroupID = annotationGroupID;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select *").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where AnnotationId = ? and AnnotationGroupId = ?");
        this.initAndProcessPrepared(this.annotationID, this.annotationGroupID);
    }

    private void loadForeignKeyObjects() {
        if (this.annotationID > -1L && this.annotation == null) {
            this.requestAnnotation();
        }
        if (this.annotationID > -1L) {
            this.requestAnnotationsList();
        }
        if (this.annotationGroupID > -1L) {
            this.requestAnnotationGroupsList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private void requestAnnotation() {
        this.annotation = new Annotations(this.getPP(), this.annotationID);
    }

    private void requestAnnotationsList() {
        for (Object obj : Annotations.getObjectIDList(this.getPP(), Annotations.class)) {
            this.annotationsList.add(new Annotations(this.getPP(), (Long)obj));
        }
    }

    private void requestAnnotationGroupsList() {
        for (Object obj : AnnotationGroups.getObjectIDList(this.getPP(), AnnotationGroups.class)) {
            if (((AnnotationGroups)obj).getAnnotationGroupID() != this.annotationGroupID) continue;
            this.annotationGroupsList.add((AnnotationGroups)obj);
        }
    }

    public long getAnnotationID() {
        return this.annotationID;
    }

    public long getAnnotationGroupID() {
        return this.annotationGroupID;
    }

    public Annotations getAnnotation() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.annotation;
    }

    public ArrayList<Annotations> getAnnotationsList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.annotationsList;
    }

    public ArrayList<AnnotationGroups> getAnnotationGroupList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.annotationGroupsList;
    }
}

