/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.PDBaseClassSinglePrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import java.sql.SQLException;

public class Annotations
extends PDBaseClassSinglePrimaryKey {
    private long annotationID = -1L;
    private String accession;
    private String description;
    private int type;

    public Annotations(AProgramParameters pp, long annotationID) {
        super(pp);
        this.annotationID = annotationID;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select Accession, Description, type").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where AnnotationID = ?");
        this.initAndProcessPrepared(this.annotationID);
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.accession = this.sql4javaSt.columnString(this.colIndex++);
                this.description = this.sql4javaSt.columnString(this.colIndex++);
                this.type = this.sql4javaSt.columnInt(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.accession = this.rs.getString(this.colIndex++);
                this.description = this.rs.getString(this.colIndex++);
                this.type = this.rs.getInt(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    public long getAnnotationID() {
        return this.annotationID;
    }

    public String getAccession() {
        return this.accession;
    }

    public String getDescription() {
        return this.description;
    }

    public int getType() {
        return this.type;
    }
}

