/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.Pair;
import de.mpc.BaseLib.RGB;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.AnnotationDataset;
import de.mpc.PD.Annotations;
import de.mpc.PD.PDBaseClass;
import de.mpc.PD.Params.AProgramParameters;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public class AnnotationGroups
extends PDBaseClass {
    private long annotationGroupID = -1L;
    private long datasetID = -1L;
    private String description;
    private int position;
    private RGB rgb = null;
    private Blob groupDefinition = null;
    private final HashMap<Pair<Long, Long>, Annotations> annotationsMap = new HashMap();
    private boolean bFilledAnnotationsMap = false;
    private AnnotationDataset annotationDataset = null;
    private final ArrayList<AnnotationDataset> annotationDatasetList = new ArrayList();

    public AnnotationGroups(AProgramParameters pp, long annotationGroupID, long datasetID) {
        super(pp);
        this.rgb = new RGB(0, 0, 0);
        this.annotationGroupID = annotationGroupID;
        this.datasetID = datasetID;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select Description, Position, ColorR, ColorG, ColorB, GroupDefinition").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where AnnotationGroupID = ? and DatasetID = ?");
        this.initAndProcessPrepared(this.annotationGroupID, this.datasetID);
    }

    private void loadForeignKeyObjects() {
        if (this.datasetID > -1L && this.annotationDataset == null) {
            this.requestAnnotationDataset();
        }
        if (this.datasetID > -1L) {
            this.requestAnnotationDatasetList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private void requestAnnotationDataset() {
        this.annotationDataset = new AnnotationDataset(this.getPP(), this.datasetID);
    }

    private void requestAnnotationDatasetList() {
        for (Object obj : AnnotationDataset.getObjectIDList(this.getPP(), AnnotationDataset.class)) {
            this.annotationDatasetList.add(new AnnotationDataset(this.getPP(), (Long)obj));
        }
    }

    @Override
    protected final void setAllMembers() {
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.description = this.sql4javaSt.columnString(1);
                this.colIndex = 3;
                this.position = this.sql4javaSt.columnInt(this.colIndex++);
                this.rgb.setRed(this.sql4javaSt.columnInt(this.colIndex++));
                this.rgb.setGreen(this.sql4javaSt.columnInt(this.colIndex++));
                this.rgb.setBlue(this.sql4javaSt.columnInt(this.colIndex++));
                this.groupDefinition = (Blob)this.sql4javaSt.columnValue(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.description = this.rs.getString(2);
                this.colIndex = 4;
                this.position = this.rs.getInt(this.colIndex++);
                this.rgb.setRed(this.rs.getInt(this.colIndex++));
                this.rgb.setGreen(this.rs.getInt(this.colIndex++));
                this.rgb.setBlue(this.rs.getInt(this.colIndex++));
                this.groupDefinition = this.rs.getBlob(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    @Override
    public long getFirstID() {
        return this.annotationGroupID;
    }

    @Override
    public long getSecondID() {
        return this.datasetID;
    }

    public long getAnnotationGroupID() {
        return this.annotationGroupID;
    }

    public long getDatasetID() {
        return this.datasetID;
    }

    public AnnotationDataset getAnnotationdatase() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.annotationDataset;
    }

    public String getDescription() {
        return this.description;
    }

    public int getPosition() {
        return this.position;
    }

    public int getColorR() {
        return this.rgb.getRed();
    }

    public int getColorG() {
        return this.rgb.getGreen();
    }

    public int getColorB() {
        return this.rgb.getBlue();
    }

    public Blob getGroupDefinition() {
        return this.groupDefinition;
    }

    public String getGroupDefinitionAsString() {
        byte[] byteArr = new byte[]{};
        try {
            int dataLen = (int)this.groupDefinition.length();
            byteArr = this.groupDefinition.getBytes(1L, dataLen);
        }
        catch (SQLException sex) {
            sex.printStackTrace(System.err);
        }
        return new String(byteArr);
    }

    public ArrayList<AnnotationDataset> getAnnotationDatasetList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.annotationDatasetList;
    }

    private HashMap<Pair<Long, Long>, Annotations> getAnnotations() {
        StringBuilder strB = new StringBuilder("select anno.AnnotationID").append(MyConstants.newline);
        strB.append("from ").append("Annotations as anno, ").append("AnnotationGroups as grp, ").append("AnnotationsAnnotationGroups as link").append(MyConstants.newline);
        strB.append("where grp.AnnotationGroupID = ").append(this.getAnnotationGroupID()).append(" and DatasetId = ").append(this.getDatasetID()).append(MyConstants.newline);
        strB.append("and link.AnnotationID = anno.AnnotationID").append(MyConstants.newline);
        strB.append("and link.AnnotationGroupID = grp.AnnotationGroupID");
        this.fillPairedPrimaryKeyGenericMap(strB.toString(), this.annotationsMap, Annotations.class, this.getAnnotationGroupID(), this.getDatasetID());
        this.bFilledAnnotationsMap = true;
        return this.annotationsMap;
    }

    public Annotations getAnnotation(long firstID, long secondID) {
        Pair keyPair;
        if (!this.bFilledAnnotationsMap) {
            this.getAnnotations();
        }
        if (this.annotationsMap.containsKey(keyPair = new Pair((Object)firstID, (Object)secondID))) {
            return this.annotationsMap.get(keyPair);
        }
        return null;
    }

    public int getNoOfAnnotations() {
        if (!this.bFilledAnnotationsMap) {
            this.getAnnotations();
        }
        return this.annotationsMap.size();
    }

    public boolean hasAnnotationLinks() {
        if (!this.bFilledAnnotationsMap) {
            this.getAnnotations();
        }
        return !this.annotationsMap.isEmpty();
    }
}

