/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.PDBaseClassSinglePrimaryKey;
import de.mpc.PD.PD_GUID;
import de.mpc.PD.Params.AProgramParameters;
import java.sql.SQLException;

public class AnnotationDataset
extends PDBaseClassSinglePrimaryKey {
    private long datasetID = -1L;
    private String name;
    private String displayName;
    private PD_GUID guid = null;
    private String description;

    public AnnotationDataset(AProgramParameters pp, long datasetID) {
        super(pp);
        this.datasetID = datasetID;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select Name, DisplayName, Guid, Description").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where DatasetId = ?");
        this.initAndProcessPrepared(this.datasetID);
    }

    private void loadGUIDObjects() {
        if (this.guid != null) assert (this.isNotNull((Object)this.guid));
        this.bGUIDObjectsLoaded = true;
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.name = this.sql4javaSt.columnString(this.colIndex++);
                this.displayName = this.sql4javaSt.columnString(this.colIndex++);
                this.guid = new PD_GUID(this.sql4javaSt.columnString(this.colIndex++));
                this.description = this.sql4javaSt.columnString(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.name = this.rs.getString(this.colIndex++);
                this.displayName = this.rs.getString(this.colIndex++);
                this.guid = new PD_GUID(this.rs.getString(this.colIndex++));
                this.description = this.rs.getString(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    public long getDatasetID() {
        return this.datasetID;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public PD_GUID getGuid() {
        return this.guid;
    }

    public String getDescription() {
        return this.description;
    }
}

