/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.AminoAcidModifications;
import de.mpc.PD.AminoAcidModificationsNeutralLosses;
import de.mpc.PD.PDBaseClassSinglePrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import java.sql.SQLException;
import java.util.HashMap;

public class AminoAcids
extends PDBaseClassSinglePrimaryKey {
    private long aminoAcidID = -1L;
    private String aminoAcidName;
    private char oneLetterCode = (char)32;
    private final char[] threeLetterCode = new char[]{' ', ' ', ' '};
    private double monoisotopicMass;
    private double averageMass;
    private String sumFormula;
    private final HashMap<Long, AminoAcidModifications> aminoAcidModificationsMap = new HashMap();
    private boolean bFilledAminoAcidModificationsMap = false;
    private final HashMap<Long, AminoAcidModificationsNeutralLosses> aminoAcidModificationsNeutralLossesMap = new HashMap();
    private boolean bFilledAminoAcidModificationsNeutralLossesMap = false;

    public AminoAcids(AProgramParameters pp, long aaID) {
        super(pp);
        this.aminoAcidID = aaID;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select AminoAcidName, OneLetterCode, ThreeLetterCode, MonoisotopicMass, AverageMass, SumFormula").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where AminoAcidID = ?");
        this.initAndProcessPrepared(this.aminoAcidID);
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.aminoAcidName = this.sql4javaSt.columnString(this.colIndex++);
                byte[] tempByteArr = this.sql4javaSt.columnBlob(this.colIndex++);
                this.oneLetterCode = (char)tempByteArr[0];
                tempByteArr = this.sql4javaSt.columnBlob(this.colIndex++);
                this.threeLetterCode[0] = (char)tempByteArr[0];
                this.threeLetterCode[1] = (char)tempByteArr[1];
                this.threeLetterCode[2] = (char)tempByteArr[2];
                this.monoisotopicMass = this.sql4javaSt.columnDouble(this.colIndex++);
                this.averageMass = this.sql4javaSt.columnDouble(this.colIndex++);
                this.sumFormula = this.sql4javaSt.columnString(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.aminoAcidName = this.rs.getString(this.colIndex++);
                byte[] tempByteArr = this.rs.getBytes(this.colIndex++);
                this.oneLetterCode = (char)tempByteArr[0];
                tempByteArr = this.rs.getBytes(this.colIndex++);
                this.threeLetterCode[0] = (char)tempByteArr[0];
                this.threeLetterCode[1] = (char)tempByteArr[1];
                this.threeLetterCode[2] = (char)tempByteArr[2];
                this.monoisotopicMass = this.rs.getDouble(this.colIndex++);
                this.averageMass = this.rs.getDouble(this.colIndex++);
                this.sumFormula = this.rs.getString(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    @Override
    public long getID() {
        return this.aminoAcidID;
    }

    public long getAminoAcidID() {
        return this.aminoAcidID;
    }

    public String getAminoAcidName() {
        return this.aminoAcidName;
    }

    public char getOneLetterCode() {
        return this.oneLetterCode;
    }

    public char[] getThreeLetterCode() {
        return this.threeLetterCode;
    }

    public double getMonoisotopicMass() {
        return this.monoisotopicMass;
    }

    public double getAverageMass() {
        return this.averageMass;
    }

    public String getSumFormula() {
        return this.sumFormula;
    }

    private HashMap<Long, AminoAcidModifications> getAminoAcidModifications() {
        StringBuilder strB = new StringBuilder("select mod.AminoAcidModificationID").append(MyConstants.newline);
        strB.append("from ").append("AminoAcids as aa, ").append("AminoAcidModifications as mod, ").append("AminoAcidModificationsAminoAcidsNL as link").append(MyConstants.newline);
        strB.append("where aa.AminoAcidID = ").append(this.getAminoAcidID()).append(MyConstants.newline);
        strB.append("and link.AminoAcidModificationID = mod.AminoAcidModificationID").append(MyConstants.newline);
        strB.append("and link.AminoAcidID = aa.AminoAcidID");
        this.fillSinglePrimaryKeyGenericMap(strB.toString(), this.aminoAcidModificationsMap, AminoAcidModifications.class, this.getAminoAcidID(), new long[0]);
        this.bFilledAminoAcidModificationsMap = true;
        return this.aminoAcidModificationsMap;
    }

    private HashMap<Long, AminoAcidModificationsNeutralLosses> getAminoAcidModificationsNeutralLosses() {
        StringBuilder strB = new StringBuilder("select mod.AminoAcidModificationID").append(MyConstants.newline);
        strB.append("from ").append("AminoAcids as aa, ").append("AminoAcidModificationsNeutralLosses as aamnl, ").append("AminoAcidModificationsAminoAcidsNL as link").append(MyConstants.newline);
        strB.append("where aa.AminoAcidID = ").append(this.getAminoAcidID()).append(MyConstants.newline);
        strB.append("and link.AminoAcidModificationID = mod.AminoAcidModificationID").append(MyConstants.newline);
        strB.append("and link.AminoAcidID = aa.AminoAcidID");
        this.fillSinglePrimaryKeyGenericMap(strB.toString(), this.aminoAcidModificationsNeutralLossesMap, AminoAcidModificationsNeutralLosses.class, this.getAminoAcidID(), new long[0]);
        this.bFilledAminoAcidModificationsNeutralLossesMap = true;
        return this.aminoAcidModificationsNeutralLossesMap;
    }

    public AminoAcidModifications getAminoAcidModification(long ID) {
        if (!this.bFilledAminoAcidModificationsMap) {
            this.getAminoAcidModifications();
        }
        if (this.aminoAcidModificationsMap.containsKey(ID)) {
            return this.aminoAcidModificationsMap.get(ID);
        }
        return null;
    }

    public int getNoOfAminoAcidModifications() {
        if (!this.bFilledAminoAcidModificationsMap) {
            this.getAminoAcidModifications();
        }
        return this.aminoAcidModificationsMap.size();
    }

    public boolean hasAminoAcidModificationsLinks() {
        if (!this.bFilledAminoAcidModificationsMap) {
            this.getAminoAcidModifications();
        }
        return !this.aminoAcidModificationsMap.isEmpty();
    }

    public AminoAcidModificationsNeutralLosses getAminoAcidModificationNeutralLosses(long ID) {
        if (!this.bFilledAminoAcidModificationsNeutralLossesMap) {
            this.getAminoAcidModificationsNeutralLosses();
        }
        if (this.aminoAcidModificationsNeutralLossesMap.containsKey(ID)) {
            return this.aminoAcidModificationsNeutralLossesMap.get(ID);
        }
        return null;
    }

    public int getNoOfAminoAcidModificationsNeutralLosses() {
        if (!this.bFilledAminoAcidModificationsNeutralLossesMap) {
            this.getAminoAcidModificationsNeutralLosses();
        }
        return this.aminoAcidModificationsNeutralLossesMap.size();
    }

    public boolean hasAminoAcidModificationsNeutralLossesLinks() {
        if (!this.bFilledAminoAcidModificationsNeutralLossesMap) {
            this.getAminoAcidModificationsNeutralLosses();
        }
        return !this.aminoAcidModificationsNeutralLossesMap.isEmpty();
    }
}

