/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.AminoAcidModifications;
import de.mpc.PD.AminoAcids;
import de.mpc.PD.PDBaseClassSinglePrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import java.sql.SQLException;
import java.util.HashMap;

public class AminoAcidModificationsNeutralLosses
extends PDBaseClassSinglePrimaryKey {
    private long neutralLossID = -1L;
    private String name;
    private double monoisotopicMass;
    private double averageMass;
    private final HashMap<Long, AminoAcids> aminoAcidsMap = new HashMap();
    private boolean bFilledAminoAcidsMap = false;
    private final HashMap<Long, AminoAcidModifications> aminoAcidModificationsMap = new HashMap();
    private boolean bFilledAminoAcidModificationsMap = false;

    public AminoAcidModificationsNeutralLosses(AProgramParameters pp, long nlID) {
        super(pp);
        this.neutralLossID = nlID;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select Name, MonoisotopicMass, AverageMass").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where NeutralLossID = ?");
        this.initAndProcessPrepared(this.neutralLossID);
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.name = this.sql4javaSt.columnString(this.colIndex++);
                this.monoisotopicMass = this.sql4javaSt.columnDouble(this.colIndex++);
                this.averageMass = this.sql4javaSt.columnDouble(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.name = this.rs.getString(this.colIndex++);
                this.monoisotopicMass = this.rs.getDouble(this.colIndex++);
                this.averageMass = this.rs.getDouble(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    @Override
    public long getID() {
        return this.neutralLossID;
    }

    public long getNeutralLossID() {
        return this.neutralLossID;
    }

    public String getName() {
        return this.name;
    }

    public double getMonoisotopicMass() {
        return this.monoisotopicMass;
    }

    public double getAverageMass() {
        return this.averageMass;
    }

    private HashMap<Long, AminoAcids> getAminoAcids() {
        StringBuilder strB = new StringBuilder("select aa.AminoAcidID").append(MyConstants.newline);
        strB.append("from ").append("AminoAcids as aa, ").append("AminoAcidModificationsNeutralLosses as aamnl, ").append("AminoAcidModificationsAminoAcidsNL as link").append(MyConstants.newline);
        strB.append("where aamnl.NeutralLossID = ").append(this.getNeutralLossID()).append(MyConstants.newline);
        strB.append("and link.AminoAcidModificationID = aamnl.NeutralLossID").append(MyConstants.newline);
        strB.append("and link.AminoAcidID = aa.AminoAcidID");
        this.fillSinglePrimaryKeyGenericMap(strB.toString(), this.aminoAcidsMap, AminoAcids.class, this.getNeutralLossID(), new long[0]);
        this.bFilledAminoAcidsMap = true;
        return this.aminoAcidsMap;
    }

    private HashMap<Long, AminoAcidModifications> getAminoAcidModifications() {
        StringBuilder strB = new StringBuilder("select mod.AminoAcidModificationID").append(MyConstants.newline);
        strB.append("from ").append("AminoAcidModificationsNeutralLosses as aamnl, ").append("AminoAcidModifications as mod, ").append("AminoAcidModificationsAminoAcidsNL as link").append(MyConstants.newline);
        strB.append("where aamnl.NeutralLossID = ").append(this.getNeutralLossID()).append(MyConstants.newline);
        strB.append("and link.AminoAcidModificationID = mod.AminoAcidModificationID").append(MyConstants.newline);
        strB.append("and link.NeutralLossID = aamnl.NeutralLossID");
        this.fillSinglePrimaryKeyGenericMap(strB.toString(), this.aminoAcidModificationsMap, AminoAcidModifications.class, this.getNeutralLossID(), new long[0]);
        this.bFilledAminoAcidModificationsMap = true;
        return this.aminoAcidModificationsMap;
    }

    public AminoAcids getAminoAcid(long ID) {
        if (!this.bFilledAminoAcidsMap) {
            this.getAminoAcids();
        }
        if (this.aminoAcidsMap.containsKey(ID)) {
            return this.aminoAcidsMap.get(ID);
        }
        return null;
    }

    public int getNoOfAminoAcids() {
        if (!this.bFilledAminoAcidsMap) {
            this.getAminoAcids();
        }
        return this.aminoAcidsMap.size();
    }

    public boolean hasAminoAcidsLinks() {
        if (!this.bFilledAminoAcidsMap) {
            this.getAminoAcids();
        }
        return !this.aminoAcidsMap.isEmpty();
    }

    public AminoAcidModifications getAminoAcidModification(long ID) {
        if (!this.bFilledAminoAcidModificationsMap) {
            this.getAminoAcidModifications();
        }
        if (this.aminoAcidModificationsMap.containsKey(ID)) {
            return this.aminoAcidModificationsMap.get(ID);
        }
        return null;
    }

    public int getNoOfAminoAcidModifications() {
        if (!this.bFilledAminoAcidModificationsMap) {
            this.getAminoAcidModifications();
        }
        return this.aminoAcidModificationsMap.size();
    }

    public boolean hasAminoAcidModificationsLinks() {
        if (!this.bFilledAminoAcidModificationsMap) {
            this.getAminoAcidModifications();
        }
        return !this.aminoAcidModificationsMap.isEmpty();
    }
}

