/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.AminoAcidModificationsNeutralLosses;
import de.mpc.PD.AminoAcids;
import de.mpc.PD.PDBaseClassSinglePrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.Peptides;
import de.mpc.PD.Peptides_decoy;
import java.sql.SQLException;
import java.util.HashMap;

public class AminoAcidModifications
extends PDBaseClassSinglePrimaryKey {
    private long aminoAcidModificationID = -1L;
    private String modificationName;
    private double deltaMass;
    private String substitution;
    private String leavingGroup;
    private String abbreviation;
    private int positionType;
    private boolean isActive;
    private double deltaAverageMass;
    private long unimodAccession;
    private boolean isSubstitution;
    private final HashMap<Long, AminoAcids> aminoAcidsMap = new HashMap();
    private boolean bFilledAminoAcidsMap = false;
    private final HashMap<Long, AminoAcidModificationsNeutralLosses> aminoAcidModificationsNeutralLossesMap = new HashMap();
    private boolean bFilledAminoAcidModificationsNeutralLossesMap = false;
    private final HashMap<Long, Peptides> peptidesMap = new HashMap();
    private boolean bFilledPeptidesMap = false;
    private final HashMap<Long, Peptides_decoy> peptidesMap_decoy = new HashMap();
    private boolean bFilledPeptidesMap_decoy = false;

    public AminoAcidModifications(AProgramParameters pp, long aaModificationID) {
        super(pp);
        this.aminoAcidModificationID = aaModificationID;
        this.initFromDB();
    }

    private void initFromDB() {
        this.sb.append("select ModificationName, DeltaMass, Substitution, LeavingGroup, Abbreviation, PositionType, IsActive, DeltaAverageMass, UnimodAccession, IsSubstitution").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where AminoAcidModificationID = ?");
        this.initAndProcessPrepared(this.aminoAcidModificationID);
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.modificationName = this.sql4javaSt.columnString(this.colIndex++);
                this.deltaMass = this.sql4javaSt.columnDouble(this.colIndex++);
                this.substitution = this.sql4javaSt.columnString(this.colIndex++);
                this.leavingGroup = this.sql4javaSt.columnString(this.colIndex++);
                this.abbreviation = this.sql4javaSt.columnString(this.colIndex++);
                this.positionType = this.sql4javaSt.columnInt(this.colIndex++);
                this.isActive = this.sql4javaSt.columnInt(this.colIndex++) == 1;
                this.deltaAverageMass = this.sql4javaSt.columnDouble(this.colIndex++);
                this.unimodAccession = this.sql4javaSt.columnLong(this.colIndex++);
                this.isSubstitution = this.sql4javaSt.columnInt(this.colIndex++) == 1;
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.modificationName = this.rs.getString(this.colIndex++);
                this.deltaMass = this.rs.getDouble(this.colIndex++);
                this.substitution = this.rs.getString(this.colIndex++);
                this.leavingGroup = this.rs.getString(this.colIndex++);
                this.abbreviation = this.rs.getString(this.colIndex++);
                this.positionType = this.rs.getInt(this.colIndex++);
                this.isActive = this.rs.getInt(this.colIndex++) == 1;
                this.deltaAverageMass = this.rs.getDouble(this.colIndex++);
                this.unimodAccession = this.rs.getLong(this.colIndex++);
                this.isSubstitution = this.rs.getInt(this.colIndex++) == 1;
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    @Override
    public long getID() {
        return this.aminoAcidModificationID;
    }

    public long getAminoAcidModificationID() {
        return this.aminoAcidModificationID;
    }

    public String getModificationName() {
        return this.modificationName;
    }

    public double getDeltaMass() {
        return this.deltaMass;
    }

    public String getSubstitution() {
        return this.substitution;
    }

    public String getLeavingGroup() {
        return this.leavingGroup;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public int getPositionType() {
        return this.positionType;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public double getDeltaAverageMass() {
        return this.deltaAverageMass;
    }

    public long getUnimodAccession() {
        return this.unimodAccession;
    }

    public boolean isSubstitution() {
        return this.isSubstitution;
    }

    private HashMap<Long, AminoAcids> getAminoAcids() {
        StringBuilder strB = new StringBuilder("select aa.AminoAcidID").append(MyConstants.newline);
        strB.append("from ").append("AminoAcids as aa, ").append("AminoAcidModifications as mod, ").append("AminoAcidModificationsAminoAcidsNL as link").append(MyConstants.newline);
        strB.append("where mod.AminoAcidModificationID = ").append(this.getAminoAcidModificationID()).append(MyConstants.newline);
        strB.append("and link.AminoAcidModificationID = mod.AminoAcidModificationID").append(MyConstants.newline);
        strB.append("and link.AminoAcidID = aa.AminoAcidID");
        this.fillSinglePrimaryKeyGenericMap(strB.toString(), this.aminoAcidsMap, AminoAcids.class, this.getAminoAcidModificationID(), new long[0]);
        this.bFilledAminoAcidsMap = true;
        return this.aminoAcidsMap;
    }

    private HashMap<Long, AminoAcidModificationsNeutralLosses> getAminoAcidModificationsNeutralLosses() {
        StringBuilder strB = new StringBuilder("select aamnl.NeutralLossID").append(MyConstants.newline);
        strB.append("from ").append("AminoAcidModificationsNeutralLosses as aamnl, ").append("AminoAcidModifications as mod, ").append("AminoAcidModificationsAminoAcidsNL as link").append(MyConstants.newline);
        strB.append("where mod.NeutralLossID = ").append(this.getAminoAcidModificationID()).append(MyConstants.newline);
        strB.append("and link.AminoAcidModificationID = mod.AminoAcidModificationID").append(MyConstants.newline);
        strB.append("and link.NeutralLossID = aamnl.NeutralLossID");
        this.fillSinglePrimaryKeyGenericMap(strB.toString(), this.aminoAcidModificationsNeutralLossesMap, AminoAcidModificationsNeutralLosses.class, this.getAminoAcidModificationID(), new long[0]);
        this.bFilledAminoAcidModificationsNeutralLossesMap = true;
        return this.aminoAcidModificationsNeutralLossesMap;
    }

    private HashMap<Long, Peptides> getPeptides(long pnn) {
        StringBuilder strB = new StringBuilder("select pept.PeptideID").append(MyConstants.newline);
        strB.append("from ").append("Peptides as pept, ").append("AminoAcidModifications as aamod, ").append("PeptidesTerminalModifications as link").append(MyConstants.newline);
        strB.append("where aamod.AminoAcidModificationID = ").append(this.getAminoAcidModificationID()).append(MyConstants.newline);
        strB.append("and aamod.ProcessingNodeNumber = ").append(pnn).append(MyConstants.newline);
        strB.append("and link.AminoAcidModificationID = aamod.AminoAcidModificationID").append(MyConstants.newline);
        strB.append("and link.ProcessingNodeNumber = aamod.ProcessingNodeNumber").append(MyConstants.newline);
        strB.append("and link.PeptideID = pept.PeptideID");
        this.fillSinglePrimaryKeyGenericMap(strB.toString(), this.peptidesMap, Peptides.class, this.getAminoAcidModificationID(), new long[0]);
        this.bFilledPeptidesMap = true;
        return this.peptidesMap;
    }

    private HashMap<Long, Peptides_decoy> getPeptides_decoy(long pnn) {
        StringBuilder strB = new StringBuilder("select pept.PeptideID").append(MyConstants.newline);
        strB.append("from ").append("Peptides_decoy as pept, ").append("AminoAcidModifications as aamod, ").append("PeptidesTerminalModifications_decoy as link").append(MyConstants.newline);
        strB.append("where aamod.AminoAcidModificationID = ").append(this.getAminoAcidModificationID()).append(MyConstants.newline);
        strB.append("and aamod.ProcessingNodeNumber = ").append(pnn).append(MyConstants.newline);
        strB.append("and link.AminoAcidModificationID = aamod.AminoAcidModificationID").append(MyConstants.newline);
        strB.append("and link.ProcessingNodeNumber = aamod.ProcessingNodeNumber").append(MyConstants.newline);
        strB.append("and link.PeptideID = pept.PeptideID");
        this.fillSinglePrimaryKeyGenericMap(strB.toString(), this.peptidesMap_decoy, Peptides_decoy.class, this.getAminoAcidModificationID(), new long[0]);
        this.bFilledPeptidesMap_decoy = true;
        return this.peptidesMap_decoy;
    }

    public AminoAcids getAminoAcid(long ID) {
        if (!this.bFilledAminoAcidsMap) {
            this.getAminoAcids();
        }
        if (this.aminoAcidsMap.containsKey(ID)) {
            return this.aminoAcidsMap.get(ID);
        }
        return null;
    }

    public int getNoOfAminoAcids() {
        if (!this.bFilledAminoAcidsMap) {
            this.getAminoAcids();
        }
        return this.aminoAcidsMap.size();
    }

    public boolean hasAminoAcidsLinks() {
        if (!this.bFilledAminoAcidsMap) {
            this.getAminoAcids();
        }
        return !this.aminoAcidsMap.isEmpty();
    }

    public AminoAcidModificationsNeutralLosses getAminoAcidModificationsNeutralLoss(long ID) {
        if (!this.bFilledAminoAcidModificationsNeutralLossesMap) {
            this.getAminoAcidModificationsNeutralLosses();
        }
        if (this.aminoAcidModificationsNeutralLossesMap.containsKey(ID)) {
            return this.aminoAcidModificationsNeutralLossesMap.get(ID);
        }
        return null;
    }

    public int getNoOfAminoAcidModificationsNeutralLosses() {
        if (!this.bFilledAminoAcidModificationsNeutralLossesMap) {
            this.getAminoAcidModificationsNeutralLosses();
        }
        return this.aminoAcidModificationsNeutralLossesMap.size();
    }

    public boolean hasAminoAcidModificationsNeutralLossesLinks() {
        if (!this.bFilledAminoAcidModificationsNeutralLossesMap) {
            this.getAminoAcidModificationsNeutralLosses();
        }
        return !this.aminoAcidModificationsNeutralLossesMap.isEmpty();
    }

    public Peptides getPeptide(long ID, long pnn) {
        if (!this.bFilledPeptidesMap) {
            this.getPeptides(pnn);
        }
        if (this.peptidesMap.containsKey(ID)) {
            return this.peptidesMap.get(ID);
        }
        return null;
    }

    public int getNoOfPeptides(long pnn) {
        if (!this.bFilledPeptidesMap) {
            this.getPeptides(pnn);
        }
        return this.peptidesMap.size();
    }

    public boolean hasPeptideLinks(long pnn) {
        if (!this.bFilledPeptidesMap) {
            this.getPeptides(pnn);
        }
        return !this.peptidesMap.isEmpty();
    }

    public Peptides_decoy getPeptide_decoy(long ID, long pnn) {
        if (!this.bFilledPeptidesMap_decoy) {
            this.getPeptides_decoy(pnn);
        }
        if (this.peptidesMap_decoy.containsKey(ID)) {
            return this.peptidesMap_decoy.get(ID);
        }
        return null;
    }

    public int getNoOfPeptides_decoy(long pnn) {
        if (!this.bFilledPeptidesMap_decoy) {
            this.getPeptides_decoy(pnn);
        }
        return this.peptidesMap_decoy.size();
    }

    public boolean hasPeptideLinks_decoy(long pnn) {
        if (!this.bFilledPeptidesMap_decoy) {
            this.getPeptides(pnn);
        }
        return !this.peptidesMap_decoy.isEmpty();
    }
}

