/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.Helper;
import de.mpc.PD.IHashCodable;
import de.mpc.PD.PDBinaryBaseClass;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.ReferenceSpectra;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;

public abstract class ASpectra
extends PDBinaryBaseClass
implements IHashCodable {
    protected long spectrumID = -1L;
    protected BigInteger spectrumHashCode = null;

    public ASpectra(AProgramParameters pp, long spectID) {
        super(pp);
        this.spectrumID = spectID;
    }

    @Override
    protected void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this instanceof ReferenceSpectra) {
            this.colIndex += 2;
        }
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.binField = (Blob)this.sql4javaSt.columnValue(this.colIndex++);
                this.spectrumHashCode = Helper.getBigIntFromStr((String)this.sql4javaSt.columnString(this.colIndex++));
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.spectrumHashCode = Helper.getBigIntFromStr((String)this.rs.getString(2));
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    public Blob getSpectrum() {
        return this.binField;
    }

    public BigInteger getSpectrumHashCode() {
        return this.spectrumHashCode;
    }

    @Override
    public BigInteger calculateHashCode(char[] text) {
        BigInteger bigInt = Helper.getBigIntFromStr((String)String.valueOf(Arrays.hashCode(text)));
        return bigInt;
    }

    public BigInteger calculateSpectrumHashCode(Blob binData) {
        String str = "";
        try {
            str = new String(this.binField.getBytes(0L, (int)this.binField.length()));
        }
        catch (SQLException sqlexc) {
            sqlexc.printStackTrace(System.err);
        }
        return this.calculateHashCode(str.toCharArray());
    }

    public String getUnzippedSpectrumXml() {
        return Helper.getUnzippedSpectrumXml((Blob)this.binField);
    }
}

