/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.IPNNable;
import de.mpc.PD.PDBaseClassPairedPrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.ProcessingNodes;
import de.mpc.PD.ProteinIdentificationGroups;
import de.mpc.PD.Proteins;
import de.mpc.PD.SMsFromPNN;
import java.sql.SQLException;
import java.util.ArrayList;

public class AProteinScores
extends PDBaseClassPairedPrimaryKey
implements IPNNable {
    protected long processingNodeNumber = -1L;
    protected long proteinID = -1L;
    protected long proteinIdentificationGroupID;
    protected double proteinScore;
    protected double coverage;
    private Proteins protein = null;
    private ProteinIdentificationGroups proteinIdentificationGroup = null;
    private ProcessingNodes processingNode = null;
    private final ArrayList<Proteins> proteinsList = new ArrayList();
    private final String searchMachine;

    public AProteinScores(AProgramParameters pp, long processingNodeNo, long proteinID) {
        super(pp);
        this.processingNodeNumber = processingNodeNo;
        this.proteinID = proteinID;
        this.searchMachine = SMsFromPNN.retrieveSearchMachineForProcessingNodeNumber(pp, this.processingNodeNumber);
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.proteinIdentificationGroupID = this.sql4javaSt.columnLong(this.colIndex++);
                this.proteinScore = this.sql4javaSt.columnDouble(this.colIndex++);
                this.coverage = this.sql4javaSt.columnDouble(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.proteinIdentificationGroupID = this.rs.getLong(this.colIndex++);
                this.proteinScore = this.rs.getDouble(this.colIndex++);
                this.coverage = this.rs.getDouble(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    protected final void initFromDB() {
        this.sb.append("select ProteinIdentificationGroupID, ProteinScore, Coverage").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where ProcessingNodeNumber = ? and ProteinID = ?");
        this.initAndProcessPrepared(this.getProcessingNodeNumber(), this.proteinID);
    }

    protected final void loadForeignKeyObjects() {
        if (this.proteinID > -1L && this.protein == null) {
            this.protein = this.requestProtein(this.proteinID);
        }
        if (this.proteinIdentificationGroupID > -1L && this.proteinIdentificationGroup == null) {
            this.proteinIdentificationGroup = this.requestProteinIdentificationGroup(this.proteinIdentificationGroupID);
        }
        if (this.processingNodeNumber > -1L && this.processingNode == null) {
            this.processingNode = this.requestProcessingNode(this.processingNodeNumber);
        }
        if (this.proteinID > -1L) {
            this.requestProteinsList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private Proteins requestProtein(long protID) {
        return new Proteins(this.getPP(), protID, strVersion);
    }

    private ProteinIdentificationGroups requestProteinIdentificationGroup(long protIdentificationGroupID) {
        return new ProteinIdentificationGroups(this.getPP(), protIdentificationGroupID, this.processingNodeNumber);
    }

    private ProcessingNodes requestProcessingNode(long processingNodeNumber) {
        return new ProcessingNodes(this.getPP(), processingNodeNumber);
    }

    private void requestProteinsList() {
        for (Object obj : Proteins.getObjectIDList(this.getPP(), Proteins.class)) {
            this.proteinsList.add(new Proteins(this.getPP(), (Long)obj, strVersion));
        }
    }

    public long getProteinID() {
        return this.proteinID;
    }

    public long getProteinIdentificationGroupID() {
        return this.proteinIdentificationGroupID;
    }

    public double getProteinScore() {
        return this.proteinScore;
    }

    public double getCoverage() {
        return this.coverage;
    }

    public Proteins getProtein() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.protein;
    }

    public ProteinIdentificationGroups getProteinIdentificationGroup() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.proteinIdentificationGroup;
    }

    @Override
    public long getProcessingNodeNumber() {
        return this.processingNodeNumber;
    }

    @Override
    public ProcessingNodes getProcessingNode() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.processingNode;
    }

    @Override
    public String getSearchMachine() {
        return this.searchMachine;
    }

    public ArrayList<Proteins> getProteinsList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.proteinsList;
    }
}

