/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.AminoAcidModifications;
import de.mpc.PD.IPNNListable;
import de.mpc.PD.PDBaseClassTripledPrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.ProcessingNodes;
import de.mpc.PD.SMsFromPNN;
import java.util.ArrayList;

public abstract class APeptidesTerminalModifications
extends PDBaseClassTripledPrimaryKey
implements IPNNListable {
    protected long processingNodeNumber = -1L;
    protected long peptideID = -1L;
    protected long terminalModificationID = -1L;
    private ProcessingNodes processingNode = null;
    private AminoAcidModifications terminalModification = null;
    private final ArrayList<ProcessingNodes> processingNodesList = new ArrayList();
    private final ArrayList<AminoAcidModifications> terminalAminoAcidModificationsList = new ArrayList();
    private final String searchMachine;

    public APeptidesTerminalModifications(AProgramParameters pp, long processingNodeNo, long peptideID, long terminalModificationID) {
        super(pp);
        this.processingNodeNumber = processingNodeNo;
        this.peptideID = peptideID;
        this.terminalModificationID = terminalModificationID;
        this.searchMachine = SMsFromPNN.retrieveSearchMachineForProcessingNodeNumber(pp, this.processingNodeNumber);
    }

    protected void loadForeignKeyObjects() {
        if (this.terminalModificationID > -1L && this.terminalModification == null) {
            this.requestTerminalAminoAcidModification();
        }
        if (this.processingNodeNumber > -1L && this.processingNode == null) {
            this.requestProcessingNode();
        }
        if (this.processingNodeNumber > -1L) {
            this.requestProcessingNodesList();
        }
        if (this.terminalModificationID > -1L) {
            this.requestTerminalModificationsList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private void requestTerminalAminoAcidModification() {
        this.terminalModification = new AminoAcidModifications(this.getPP(), this.terminalModificationID);
    }

    private void requestProcessingNode() {
        this.processingNode = new ProcessingNodes(this.getPP(), this.processingNodeNumber);
    }

    private void requestProcessingNodesList() {
        for (Object obj : ProcessingNodes.getObjectIDList(this.getPP(), ProcessingNodes.class)) {
            this.processingNodesList.add(new ProcessingNodes(this.getPP(), (Long)obj));
        }
    }

    private void requestTerminalModificationsList() {
        for (Object obj : AminoAcidModifications.getObjectIDList(this.getPP(), AminoAcidModifications.class)) {
            this.terminalAminoAcidModificationsList.add(new AminoAcidModifications(this.getPP(), (Long)obj));
        }
    }

    @Override
    protected final void setAllMembers() {
    }

    protected final void initFromDB() {
        this.sb.append("select *").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where ProcessingNodeNumber = ? and PeptideID = ? and TerminalModificationID = ?");
        this.initAndProcessPrepared(this.getProcessingNodeNumber(), this.peptideID, this.terminalModificationID);
    }

    public long getPeptideID() {
        return this.peptideID;
    }

    public long getTerminalModificationID() {
        return this.terminalModificationID;
    }

    public AminoAcidModifications getTerminalAminoAcidModification() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.terminalModification;
    }

    public ProcessingNodes getProcessingNode() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.processingNode;
    }

    @Override
    public long getProcessingNodeNumber() {
        return this.processingNodeNumber;
    }

    @Override
    public ArrayList<ProcessingNodes> getProcessingNodesList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.processingNodesList;
    }

    public ArrayList<AminoAcidModifications> getAminoAcidModificationslist() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.terminalAminoAcidModificationsList;
    }

    @Override
    public String getSearchMachine() {
        return this.searchMachine;
    }
}

