/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.IPNNListable;
import de.mpc.PD.PDBaseClassTripledPrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.ProcessingNodes;
import de.mpc.PD.Proteins;
import de.mpc.PD.SMsFromPNN;
import java.util.ArrayList;

public abstract class APeptidesProteins
extends PDBaseClassTripledPrimaryKey
implements IPNNListable {
    protected long processingNodeNumber = -1L;
    protected long peptideID = -1L;
    protected long proteinID = -1L;
    private ProcessingNodes processingNode = null;
    private Proteins protein = null;
    private final ArrayList<ProcessingNodes> processingNodesList = new ArrayList();
    private final ArrayList<Proteins> proteinsList = new ArrayList();
    private final String searchMachine;

    public APeptidesProteins(AProgramParameters pp, long processingNodeNo, long peptideID, long proteinID) {
        super(pp);
        this.processingNodeNumber = processingNodeNo;
        this.peptideID = peptideID;
        this.proteinID = proteinID;
        this.searchMachine = SMsFromPNN.retrieveSearchMachineForProcessingNodeNumber(pp, this.processingNodeNumber);
    }

    protected void loadForeignKeyObjects() {
        if (this.processingNodeNumber > -1L && this.processingNode == null) {
            this.requestProcessingNode();
        }
        if (this.proteinID > -1L && this.protein == null) {
            this.requestProtein();
        }
        if (this.processingNodeNumber > -1L) {
            this.requestProcessingNodesList();
        }
        if (this.proteinID > -1L) {
            this.requestProteinsList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private void requestProcessingNode() {
        this.processingNode = new ProcessingNodes(this.getPP(), this.processingNodeNumber);
    }

    private void requestProtein() {
        this.protein = new Proteins(this.getPP(), this.proteinID, strVersion);
    }

    private void requestProcessingNodesList() {
        for (Object obj : ProcessingNodes.getObjectIDList(this.getPP(), ProcessingNodes.class)) {
            this.processingNodesList.add(new ProcessingNodes(this.getPP(), (Long)obj));
        }
    }

    private void requestProteinsList() {
        for (Object obj : Proteins.getObjectIDList(this.getPP(), Proteins.class)) {
            this.proteinsList.add(new Proteins(this.getPP(), (Long)obj, strVersion));
        }
    }

    @Override
    protected void setAllMembers() {
    }

    protected final void initFromDB() {
        this.sb.append("select *").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where ProcessingNodeNumber = ? and PeptideID = ? and ProteinID = ?");
        this.initAndProcessPrepared(this.getProcessingNodeNumber(), this.peptideID, this.proteinID);
    }

    public long getPeptideID() {
        return this.peptideID;
    }

    public long getProteinID() {
        return this.proteinID;
    }

    public ProcessingNodes getProcessingNode() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.processingNode;
    }

    public Proteins getProtein() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.protein;
    }

    @Override
    public long getProcessingNodeNumber() {
        return this.processingNodeNumber;
    }

    @Override
    public ArrayList<ProcessingNodes> getProcessingNodesList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.processingNodesList;
    }

    public ArrayList<Proteins> getProteinsList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.proteinsList;
    }

    @Override
    public String getSearchMachine() {
        return this.searchMachine;
    }
}

