/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.AminoAcidModifications;
import de.mpc.PD.IPNNable;
import de.mpc.PD.PDBaseClassQuadrupledPrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.ProcessingNodes;
import de.mpc.PD.SMsFromPNN;

public abstract class APeptidesAminoAcidModifications
extends PDBaseClassQuadrupledPrimaryKey
implements IPNNable {
    protected long processingNodeNumber = -1L;
    protected long peptideID = -1L;
    protected long aminoAcidModificationID = -1L;
    protected long position = -1L;
    private AminoAcidModifications aminoAcidModification = null;
    private ProcessingNodes processingNode = null;
    String searchMachine;

    protected APeptidesAminoAcidModifications(AProgramParameters pp, long processingNodeNo, long peptideID, long aminoAcidModificationID, long position) {
        super(pp);
        this.processingNodeNumber = processingNodeNo;
        this.peptideID = peptideID;
        this.aminoAcidModificationID = aminoAcidModificationID;
        this.position = position;
        this.searchMachine = SMsFromPNN.retrieveSearchMachineForProcessingNodeNumber(pp, this.processingNodeNumber);
    }

    protected final void initFromDB() {
        this.sb.append("select *").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where ProcessingNodeNumber = ? and PeptideID = ? and AminoAcidModificationID = ? and position = ?");
        this.initAndProcessPrepared(this.getProcessingNodeNumber(), this.peptideID, this.aminoAcidModificationID, this.position);
    }

    private void loadForeignKeyObjects() {
        if (this.aminoAcidModificationID > -1L && this.aminoAcidModification == null) {
            this.aminoAcidModification = this.requestAminoAcidModification(this.aminoAcidModificationID);
        }
        if (this.processingNodeNumber > -1L && this.processingNode == null) {
            this.processingNode = this.requestProcessingNode(this.processingNodeNumber);
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private AminoAcidModifications requestAminoAcidModification(long aaModID) {
        return new AminoAcidModifications(this.getPP(), aaModID);
    }

    private ProcessingNodes requestProcessingNode(long pNN) {
        return new ProcessingNodes(this.getPP(), pNN);
    }

    @Override
    protected void setAllMembers() {
    }

    public long getPeptideID() {
        return this.peptideID;
    }

    public long getAminoAcidModificationID() {
        return this.aminoAcidModificationID;
    }

    public long getPosition() {
        return this.position;
    }

    @Override
    public long getProcessingNodeNumber() {
        return this.processingNodeNumber;
    }

    public AminoAcidModifications getAminoAcidModification() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.aminoAcidModification;
    }

    @Override
    public ProcessingNodes getProcessingNode() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.processingNode;
    }

    @Override
    public String getSearchMachine() {
        return this.searchMachine;
    }
}

