/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import de.mpc.BaseLib.Pair;
import de.mpc.CvtBaseLib.CVHelper;
import de.mpc.MzIdentML11Wrapper.CvCreator;
import de.mpc.MzIdentML11Wrapper.CvParamCreator;
import de.mpc.PD.AminoAcidModifications;
import de.mpc.PD.CustomDataFields;
import de.mpc.PD.IPNNable;
import de.mpc.PD.PDBaseClassPairedPrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.ProcessingNodes;
import de.mpc.PD.Proteins;
import de.mpc.PD.SMsFromPNN;
import de.mpc.PD.SpectrumHeaders;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class APeptides
extends PDBaseClassPairedPrimaryKey
implements IPNNable {
    protected long processingNodeNumber = -1L;
    protected long peptideID = -1L;
    protected long spectrumID;
    protected short totalIonsCount;
    protected short matchedIonsCount;
    protected short confidenceLevel;
    protected int searchEngineRank;
    protected String sequence = "";
    protected String annotation;
    protected long uniquePeptideSequenceID;
    protected short missedCleavages;
    private SpectrumHeaders spectrumHeader = null;
    private ProcessingNodes processingNode = null;
    private final ArrayList<SpectrumHeaders> spectrumList = new ArrayList();
    private final ArrayList<ProcessingNodes> processingNodesList = new ArrayList();
    protected final HashMap<Pair<Long, Long>, CustomDataFields> customDataMap = new HashMap();
    protected boolean bFilledCustomDataMap = false;
    protected final HashMap<Pair<Long, Long>, Proteins> proteinsMap = new HashMap();
    protected boolean bFilledProteinsMap = false;
    protected final HashMap<Pair<Long, Long>, AminoAcidModifications> terminalModificationsMap = new HashMap();
    protected boolean bFilledTerminalModificationsMap = false;
    private final String searchMachine;

    protected APeptides(AProgramParameters pp, long processingNodeNo, long peptideID) {
        super(pp);
        this.processingNodeNumber = processingNodeNo;
        this.peptideID = peptideID;
        this.searchMachine = SMsFromPNN.retrieveSearchMachineForProcessingNodeNumber(pp, this.processingNodeNumber);
    }

    protected final void loadForeignKeyObjects() {
        if (this.spectrumID > -1L && this.spectrumHeader == null) {
            this.spectrumHeader = this.requestSpectrumHeader(this.spectrumID);
        }
        if (this.processingNodeNumber > -1L && this.processingNode == null) {
            this.processingNode = this.requestProcessingNode(this.processingNodeNumber);
        }
        if (this.spectrumID > -1L) {
            this.requestSpectrumList();
        }
        if (this.processingNodeNumber > -1L) {
            this.requestProcessingNodesList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private SpectrumHeaders requestSpectrumHeader(long spectID) {
        return new SpectrumHeaders(this.getPP(), spectID);
    }

    private ProcessingNodes requestProcessingNode(long processingNodeNumber) {
        return new ProcessingNodes(this.getPP(), processingNodeNumber);
    }

    private void requestSpectrumList() {
        for (Object obj : SpectrumHeaders.getObjectIDList(this.getPP(), SpectrumHeaders.class)) {
            this.spectrumList.add(new SpectrumHeaders(this.getPP(), (Long)obj));
        }
    }

    private void requestProcessingNodesList() {
        for (Object obj : ProcessingNodes.getObjectIDList(this.getPP(), ProcessingNodes.class)) {
            this.processingNodesList.add(new ProcessingNodes(this.getPP(), (Long)obj));
        }
    }

    public long getPeptideID() {
        return this.peptideID;
    }

    public long getSpectrumID() {
        return this.spectrumID;
    }

    public short getTotalIonsCount() {
        return this.totalIonsCount;
    }

    public short getMatchedIonsCount() {
        return this.matchedIonsCount;
    }

    public short getConfidenceLevel() {
        return this.confidenceLevel;
    }

    public int getSearchEngineRank() {
        return this.searchEngineRank;
    }

    public String getSequence() {
        return this.sequence;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public long getUniquePeptideSequenceID() {
        return this.uniquePeptideSequenceID;
    }

    public short getMissedCleavages() {
        return this.missedCleavages;
    }

    private CvParamCreator getMascotTotalIonsCountCVTerm() {
        CvParamCreator cpc = CVHelper.getCvParamCreator((String)"MS:1001174", (String)"Mascot:total ions", (CvCreator)CVHelper.getCvCreator((String)"MS"));
        cpc.setValue(String.valueOf(this.totalIonsCount));
        return cpc;
    }

    private CvParamCreator getMascotMatchedIonsCountCVTerm() {
        CvParamCreator cpc = CVHelper.getCvParamCreator((String)"MS:1001173", (String)"Mascot:matched ions", (CvCreator)CVHelper.getCvCreator((String)"MS"));
        cpc.setValue(String.valueOf(this.matchedIonsCount));
        return cpc;
    }

    private CvParamCreator getSequestTotalIonsCountCVTerm() {
        CvParamCreator cpc = CVHelper.getCvParamCreator((String)"MS:1001162", (String)"Sequest:total ions", (CvCreator)CVHelper.getCvCreator((String)"MS"));
        cpc.setValue(String.valueOf(this.totalIonsCount));
        return cpc;
    }

    private CvParamCreator getSequestMatchedIonsCountCVTerm() {
        CvParamCreator cpc = CVHelper.getCvParamCreator((String)"MS:1001161", (String)"Sequest:matched ions", (CvCreator)CVHelper.getCvCreator((String)"MS"));
        cpc.setValue(String.valueOf(this.matchedIonsCount));
        return cpc;
    }

    public CvParamCreator getTotalIonsCountCVTerm() {
        switch (this.searchMachine) {
            case "Mascot": {
                return this.getMascotTotalIonsCountCVTerm();
            }
            case "SEQUEST": {
                return this.getSequestTotalIonsCountCVTerm();
            }
        }
        this.logger.warn("Unhandled smName {} in getTotalIonsCountCVTerm()");
        return null;
    }

    public CvParamCreator getMatchedIonsCountCVTerm() {
        switch (this.searchMachine) {
            case "Mascot": {
                return this.getMascotMatchedIonsCountCVTerm();
            }
            case "SEQUEST": {
                return this.getSequestMatchedIonsCountCVTerm();
            }
        }
        this.logger.warn("Unhandled smName {} in getMatchedIonsCountCVTerm()");
        return null;
    }

    public ArrayList<ProcessingNodes> getProcessingNodesList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.processingNodesList;
    }

    public ArrayList<SpectrumHeaders> getSpectrumList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.spectrumList;
    }

    public SpectrumHeaders getSpectrumHeader() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.spectrumHeader;
    }

    protected HashMap<Pair<Long, Long>, CustomDataFields> getCustomDataFields() {
        this.logger.error("getCustomDataFields() must be overridden for class {}.", (Object)this.getClass().getName());
        return null;
    }

    protected HashMap<Pair<Long, Long>, Proteins> getProteins() {
        this.logger.error("getProteins() must be overridden for class {}.", (Object)this.getClass().getName());
        return null;
    }

    protected HashMap<Pair<Long, Long>, AminoAcidModifications> getTerminalModifications() {
        this.logger.error("getTerminalModifications() must be overridden for class {}.", (Object)this.getClass().getName());
        return null;
    }

    public CustomDataFields getCustomData(long firstID, long secondID) {
        Pair keyPair;
        if (!this.bFilledCustomDataMap) {
            this.getCustomDataFields();
        }
        if (this.customDataMap.containsKey(keyPair = new Pair((Object)firstID, (Object)secondID))) {
            return this.customDataMap.get(keyPair);
        }
        return null;
    }

    public int getNoOfCustomData() {
        if (!this.bFilledCustomDataMap) {
            this.getCustomDataFields();
        }
        return this.customDataMap.size();
    }

    public boolean hasCustomDataLinks() {
        if (!this.bFilledCustomDataMap) {
            this.getCustomDataFields();
        }
        return !this.customDataMap.isEmpty();
    }

    public Proteins getProtein(long firstID, long secondID) {
        Pair keyPair;
        if (!this.bFilledProteinsMap) {
            this.getProteins();
        }
        if (this.proteinsMap.containsKey(keyPair = new Pair((Object)firstID, (Object)secondID))) {
            return this.proteinsMap.get(keyPair);
        }
        return null;
    }

    public int getNoOfProteins() {
        if (!this.bFilledProteinsMap) {
            this.getProteins();
        }
        return this.proteinsMap.size();
    }

    public boolean hasProteinLinks() {
        if (!this.bFilledProteinsMap) {
            this.getProteins();
        }
        return !this.proteinsMap.isEmpty();
    }

    public AminoAcidModifications getTerminalModification(long firstID, long secondID) {
        Pair keyPair;
        if (!this.bFilledTerminalModificationsMap) {
            this.getTerminalModifications();
        }
        if (this.terminalModificationsMap.containsKey(keyPair = new Pair((Object)firstID, (Object)secondID))) {
            return this.terminalModificationsMap.get(keyPair);
        }
        return null;
    }

    public int getNoOfTerminalModifications() {
        if (!this.bFilledTerminalModificationsMap) {
            this.getTerminalModifications();
        }
        return this.terminalModificationsMap.size();
    }

    public boolean hasTerminalModificationLinks() {
        if (!this.bFilledTerminalModificationsMap) {
            this.getTerminalModifications();
        }
        return !this.terminalModificationsMap.isEmpty();
    }

    @Override
    public long getProcessingNodeNumber() {
        return this.processingNodeNumber;
    }

    @Override
    public ProcessingNodes getProcessingNode() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.processingNode;
    }

    @Override
    public String getSearchMachine() {
        return this.searchMachine;
    }
}

