/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.IPNNable;
import de.mpc.PD.PDBaseClassTripledPrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.ProcessingNodeScores;
import de.mpc.PD.ProcessingNodes;
import de.mpc.PD.SMsFromPNN;
import java.sql.SQLException;

public abstract class APeptideScores
extends PDBaseClassTripledPrimaryKey
implements IPNNable {
    protected long processingNodeNumber = -1L;
    protected long peptideID = -1L;
    protected long scoreID = -1L;
    private long processingNodeID;
    private double scoreValue;
    private ProcessingNodeScores processingNodeScore = null;
    private ProcessingNodes processingNode = null;
    private final String searchMachine;

    protected APeptideScores(AProgramParameters pp, long processingNodeNo, long peptideID, long scoreID) {
        super(pp);
        this.processingNodeNumber = processingNodeNo;
        this.peptideID = peptideID;
        this.scoreID = scoreID;
        this.searchMachine = SMsFromPNN.retrieveSearchMachineForProcessingNodeNumber(pp, this.processingNodeNumber);
    }

    @Override
    protected final void setAllMembers() {
        this.colIndex = this.getStartingColIndex();
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.processingNodeID = this.sql4javaSt.columnLong(this.colIndex++);
                this.scoreValue = this.sql4javaSt.columnDouble(this.colIndex++);
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.processingNodeID = this.rs.getLong(this.colIndex++);
                this.scoreValue = this.rs.getDouble(this.colIndex++);
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    protected final void initFromDB() {
        this.sb.append("select ProcessingNodeID, ScoreValue").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where ProcessingNodeNumber = ? and PeptideID = ? and ScoreID = ?");
        this.initAndProcessPrepared(this.getProcessingNodeNumber(), this.peptideID, this.scoreID);
    }

    protected void loadForeignKeyObjects() {
        if (this.scoreID > -1L && this.processingNodeScore == null) {
            this.processingNodeScore = this.requestProcessingNodeScore(this.scoreID);
        }
        if (this.processingNodeNumber > -1L && this.processingNode == null) {
            this.processingNode = this.requestProcessingNode(this.processingNodeNumber);
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private ProcessingNodeScores requestProcessingNodeScore(long scoreID) {
        return new ProcessingNodeScores(this.getPP(), scoreID);
    }

    private ProcessingNodes requestProcessingNode(long processingNodeNumber) {
        return new ProcessingNodes(this.getPP(), processingNodeNumber);
    }

    public long getPeptideID() {
        return this.peptideID;
    }

    public long getScoreID() {
        return this.scoreID;
    }

    public long getProcessingNodeID() {
        return this.processingNodeID;
    }

    public double getScoreValue() {
        return this.scoreValue;
    }

    public ProcessingNodeScores getProcessingNodeScore() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.processingNodeScore;
    }

    @Override
    public long getProcessingNodeNumber() {
        return this.processingNodeNumber;
    }

    @Override
    public ProcessingNodes getProcessingNode() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.processingNode;
    }

    @Override
    public String getSearchMachine() {
        return this.searchMachine;
    }
}

