/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import de.mpc.PD.IPNNable;
import de.mpc.PD.PDBaseClassPairedPrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.ProcessingNodes;
import de.mpc.PD.SMsFromPNN;
import de.mpc.PD.SpectrumHeaders;

public abstract class AIonQuanResultsSearchSpectra
extends PDBaseClassPairedPrimaryKey
implements IPNNable {
    protected long processingNodeNumber = -1L;
    protected long searchSpectrumID = -1L;
    private SpectrumHeaders searchSpectrum = null;
    private ProcessingNodes processingNode = null;
    private final String searchMachine;

    public AIonQuanResultsSearchSpectra(AProgramParameters pp, long processingNodeNo) {
        super(pp);
        this.processingNodeNumber = processingNodeNo;
        this.searchMachine = SMsFromPNN.retrieveSearchMachineForProcessingNodeNumber(pp, this.processingNodeNumber);
    }

    protected void loadForeignKeyObjects() {
        if (this.searchSpectrumID > -1L && this.searchSpectrum == null) {
            this.searchSpectrum = this.requestSearchSpectrum(this.searchSpectrumID);
        }
        if (this.processingNodeNumber > -1L && this.processingNode == null) {
            this.processingNode = this.requestProcessingNode(this.processingNodeNumber);
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private SpectrumHeaders requestSearchSpectrum(long searchSpectID) {
        return new SpectrumHeaders(this.getPP(), searchSpectID);
    }

    private ProcessingNodes requestProcessingNode(long processingNodeNumber) {
        return new ProcessingNodes(this.getPP(), processingNodeNumber);
    }

    public long getSearchSpectrumID() {
        return this.searchSpectrumID;
    }

    public SpectrumHeaders getSearchSpectrum() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.searchSpectrum;
    }

    @Override
    public long getProcessingNodeNumber() {
        return this.processingNodeNumber;
    }

    @Override
    public ProcessingNodes getProcessingNode() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.processingNode;
    }

    @Override
    public String getSearchMachine() {
        return this.searchMachine;
    }
}

