/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.Variant;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.CustomDataFields;
import de.mpc.PD.PDBaseClassPairedPrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import de.mpc.PD.Proteins;
import java.sql.SQLException;
import java.util.ArrayList;

public abstract class ACustomDataProteins
extends PDBaseClassPairedPrimaryKey {
    protected long fieldID = -1L;
    protected long proteinID = -1L;
    protected Variant fieldValue = null;
    private CustomDataFields customDataField = null;
    private Proteins protein = null;
    private final ArrayList<CustomDataFields> customDataFieldsList = new ArrayList();
    private final ArrayList<Proteins> proteinsList = new ArrayList();

    public ACustomDataProteins(AProgramParameters pp, long fieldID, long proteinID, Variant varValue) {
        super(pp);
        this.setInitialValues(fieldID, proteinID, varValue);
    }

    public ACustomDataProteins(AProgramParameters pp, long fieldID, long proteinID) {
        super(pp);
        this.setInitialValues(fieldID, proteinID, new Variant(""));
    }

    private void setInitialValues(long fieldID, long proteinID, Variant varValue) {
        this.fieldID = fieldID;
        this.proteinID = proteinID;
        this.fieldValue = varValue;
        this.initFromDB();
    }

    @Override
    protected final void setAllMembers() {
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.fieldValue = new Variant(this.sql4javaSt.columnString(this.getStartingColIndex()));
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.fieldValue = new Variant(this.rs.getString(this.getStartingColIndex()));
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    protected final void initFromDB() {
        this.sb.append("select FieldValue").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where FieldID = ? and ProteinID = ?");
        this.initAndProcessPrepared(this.fieldID, this.proteinID);
    }

    protected final void loadForeignKeyObjects() {
        if (this.fieldID > -1L && this.customDataField == null) {
            this.requestCustomDataField();
        }
        if (this.proteinID > -1L && this.protein == null) {
            this.requestProtein();
        }
        if (this.fieldID > -1L) {
            this.requestCustomDataFieldsList();
        }
        if (this.proteinID > -1L) {
            this.requestProteinsList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private void requestCustomDataField() {
        this.customDataField = new CustomDataFields(this.getPP(), this.fieldID);
    }

    private void requestProtein() {
        this.protein = new Proteins(this.getPP(), this.proteinID, strVersion);
    }

    private void requestCustomDataFieldsList() {
        for (Object obj : CustomDataFields.getObjectIDList(this.getPP(), CustomDataFields.class)) {
            this.customDataFieldsList.add(new CustomDataFields(this.getPP(), (Long)obj));
        }
    }

    private void requestProteinsList() {
        for (Object obj : Proteins.getObjectIDList(this.getPP(), Proteins.class)) {
            if (((Proteins)obj).getProteinID() != this.proteinID) continue;
            this.proteinsList.add((Proteins)obj);
        }
    }

    public long getFieldID() {
        return this.fieldID;
    }

    public long getProteinID() {
        return this.proteinID;
    }

    public long getFieldValueAsLong() {
        return this.fieldValue.getLongValue();
    }

    public double getFieldValueAsDouble() {
        return this.fieldValue.getDoubleValue();
    }

    public CustomDataFields getCustomDataField() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.customDataField;
    }

    public Proteins getProtein() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.protein;
    }

    public ArrayList<CustomDataFields> getCustomDataFieldsList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.customDataFieldsList;
    }

    public ArrayList<Proteins> getProteinsList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.proteinsList;
    }
}

