/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.PD;

import com.almworks.sqlite4java.SQLiteException;
import de.mpc.BaseLib.Variant;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.PD.CustomDataFields;
import de.mpc.PD.PDBaseClassPairedPrimaryKey;
import de.mpc.PD.Params.AProgramParameters;
import java.sql.SQLException;
import java.util.ArrayList;

public abstract class ACustomDataPeptides
extends PDBaseClassPairedPrimaryKey {
    protected long fieldID = -1L;
    protected long peptideID = -1L;
    protected Variant fieldValue = null;
    private CustomDataFields customDataField = null;
    private final ArrayList<CustomDataFields> customDataFieldsList = new ArrayList();

    public ACustomDataPeptides(AProgramParameters pp, long fieldID, long peptideID, Variant varValue) {
        super(pp);
        this.setInitialValues(fieldID, peptideID, varValue);
    }

    public ACustomDataPeptides(AProgramParameters pp, long fieldID, long peptideID) {
        super(pp);
        this.setInitialValues(fieldID, peptideID, new Variant(""));
    }

    private void setInitialValues(long fieldID, long peptideID, Variant varValue) {
        this.fieldID = fieldID;
        this.peptideID = peptideID;
        this.fieldValue = varValue;
        this.initFromDB();
    }

    @Override
    protected final void setAllMembers() {
        if (this.getPP().isUsingSQLite4Java()) {
            try {
                this.fieldValue = new Variant(this.sql4javaSt.columnString(this.getStartingColIndex()));
            }
            catch (SQLiteException sqliteex) {
                this.handleSQLiteException(sqliteex);
            }
        } else {
            try {
                this.fieldValue = new Variant(this.rs.getString(this.getStartingColIndex()));
            }
            catch (SQLException sqlex) {
                this.handleSQLException(sqlex);
            }
        }
    }

    protected final void initFromDB() {
        this.sb.append("select FieldValue").append(MyConstants.newline);
        this.sb.append(this.getFromLine());
        this.sb.append("where FieldID = ? and PeptideID = ?");
        this.initAndProcessPrepared(this.fieldID, this.peptideID);
    }

    protected void loadForeignKeyObjects() {
        if (this.fieldID > -1L && this.customDataField == null) {
            this.requestCustomDataField();
        }
        if (this.fieldID > -1L) {
            this.requestCustomDataFieldsList();
        }
        this.bForeignKeyObjectsLoaded = true;
    }

    private void requestCustomDataField() {
        this.customDataField = new CustomDataFields(this.getPP(), this.fieldID);
    }

    private void requestCustomDataFieldsList() {
        for (Object obj : CustomDataFields.getObjectIDList(this.getPP(), CustomDataFields.class)) {
            this.customDataFieldsList.add(new CustomDataFields(this.getPP(), (Long)obj));
        }
    }

    public long getFieldID() {
        return this.fieldID;
    }

    public long getPeptideID() {
        return this.peptideID;
    }

    public long getFieldValueAsLong() {
        return this.fieldValue.getLongValue();
    }

    public double getFieldValueAsDouble() {
        return this.fieldValue.getDoubleValue();
    }

    public CustomDataFields getCustomDataField() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.customDataField;
    }

    public ArrayList<CustomDataFields> getCustomDataFieldList() {
        if (!this.bForeignKeyObjectsLoaded) {
            this.loadForeignKeyObjects();
        }
        return this.customDataFieldsList;
    }
}

